(function($) {

    $.su = $.su || {};
    $.su.CHAR = $.su.CHAR || {};
    $.su.CHAR.HELP = {
        STATUS_INTERNET: {
            TITLE: "인터넷",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "광역 네트워크 (인터넷) 연결에 대한 관련 정보를 표시합니다."
                }, {
                    type: "title",
                    title: "IPv4"
                }, {
                    type: "name",
                    title: "MAC 주소",
                    content: "공유기의 인터넷 (WAN) 포트에 할당 된 고유 한 물리적 주소입니다."
                }, {
                    type: "name",
                    title: "IP 주소",
                    content: "공유기의 인터넷 (WAN) 포트에 할당 된 IP 주소입니다. IP 주소가 0.0.0.0으로 표시되면 인터넷에 액세스 할 수 없음을 나타냅니다."
                }, {
                    type: "name",
                    title: "서브넷 마스크",
                    content: "이 매개 변수는 IP 주소의 네트워크 부분과 호스트 부분을 결정합니다."
                }, {
                    type: "name",
                    title: "기본 게이트웨이",
                    content: "공유기를 네트워크에 연결하는 데 사용되는 IP 주소입니다."
                }, {
                    type: "name",
                    title: "기본 DNS / 보조 DNS",
                    content: "도메인 이름 시스템 (DNS)은 호스트 이름과 인터넷 도메인을 IP 주소로 변환합니다. 이러한 DNS 서버의 정보는 인터넷 서비스 공급자 (ISP)가 할당합니다."
                }, {
                    type: "name",
                    title: "연결 유형",
                    content: "인터넷 (WAN) 포트의 현재 연결 유형입니다."
                }, {
                    type: "title",
                    title: "IPv6"
                }, {
                    type: "name",
                    title: "MAC 주소",
                    content: "공유기의 인터넷 (WAN) 포트에 할당 된 고유 한 물리적 주소입니다."
                }, {
                    type: "name",
                    title: "IP 주소",
                    content: "공유기의 인터넷 (WAN) 포트에 할당 된 IP 주소입니다."
                }, {
                    type: "name",
                    title: "기본 게이트웨이",
                    content: "공유기를 네트워크에 연결하는 데 사용되는 IP 주소입니다."
                }, {
                    type: "name",
                    title: "기본 DNS / 보조 DNS",
                    content: "도메인 이름 시스템 (DNS)은 호스트 이름과 인터넷 도메인을 IP 주소로 변환합니다. 이러한 DNS 서버의 정보는 인터넷 서비스 공급자 (ISP)가 할당합니다."
                }, {
                    type: "name",
                    title: "연결 유형",
                    content: "인터넷 (WAN) 포트의 현재 연결 유형입니다."
                }
            ]
        },
        STATUS_PLC_NTW: {
            TITLE: "파워라인 네트웨크",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "파워라인 네트워크 아이콘을 클릭하면 현재 파워라인 네트워크에있는 모든 파워라인 장치 목록이 표시됩니다."
                }
            ]
        },
        STATUS_PLC: {
            TITLE: "파워라인",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "파워라인 아이콘을 클릭하면 해당 지역의 파워라인 익스텐더에 대한 자세한 정보가 표시됩니다."
                }, {
                    type: "name",
                    title: "MAC 주소",
                    content: "파워라인 익스텐더에 할당 된 고유 식별자"
                }, {
                    type: "name",
                    title: "파워라인 키",
                    content: "파워라인 네트워크에 추가 될 때 사용되는이 파워라인 장치의 고유 키. 키는 제품 라벨에도 푯시되어 있습니다."
                }, {
                    type: "name",
                    title: "네트워크 이름",
                    content: "파워라인 익스텐더가 있는 네트워크 이름입니다. 기본값은 HomePlugAV입니다"
                }
            ]
        },
        STATUS_WIRELESS: {
            TITLE: "2.4GHz<span class=\"anti_5g\">/5GHz</span> 무선 네트워크",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "무선 네트워크의 상태 및 기본 정보를 표시합니다."
                }, {
                    type: "name",
                    title: "상태",
                    content: "무선 네트워크의 현재 상태 (설정 또는 해제)."
                }, {
                    type: "name",
                    title: "SSID",
                    content: "서비스 세트 식별자 (무선 네트워크 이름이라고도 함)"
                }, {
                    type: "name",
                    title: "채널",
                    content: "현재 무선 채널입니다"
                }, {
                    type: "name",
                    title: "MAC",
                    content: "파워라인 익스텐더의 무선 라디오의 MAC 주소."
                }
            ]
        },
        STATUS_LAN: {
            TITLE: "LAN",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "이더넷 (LAN) 포트에 대한 정보를 표시합니다."
                }, {
                    type: "title",
                    title: "IPv4"
                }, {
                    type: "name",
                    title: "MAC 주소",
                    content: "공유기의 이더넷 (LAN) 포트에 할당 된 고유 한 물리적 주소입니다."
                }, {
                    type: "name",
                    title: "IP 주소",
                    content: ""
                }, {
                    type: "name",
                    title: "기본 게이트웨이",
                    content: "이 매개 변수는 IP 주소의 네트워크 부분과 호스트 부분을 결정합니다."
                }, {
                    type: "name",
                    title: "DHCP",
                    content: "공유기의 내장 DHCP 서버가 LAN 포트에있는 장치에 대해 활성화되어 있는지 여부를 표시합니다."
                }, {
                    type: "title",
                    title: "IPv6"
                }, {
                    type: "name",
                    title: "MAC 주소",
                    content: "공유기의 이더넷 (LAN) 포트에 할당 된 고유 한 물리적 주소입니다."
                }, {
                    type: "name",
                    title: "IP 주소",
                    content: "공유기의 인터넷 (LAN) 포트에 할당 된 IPv6 주소입니다."
                }, {
                    type: "name",
                    title: "링크 로컬 주소",
                    content: "LAN 인터페이스의 IPv6 링크 주소입니다."
                }, {
                    type: "name",
                    title: "지정된 유형",
                    content: "LAN 인터페이스의 IPv6 주소 유형입니다"
                }
            ]
        },
        STATUS_GUEST: {
            TITLE: "2.4GHz<span class=\"anti_5g\">/5GHz</span> 게스트 네트워크",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "게스트 용 무선 네트워크에 대한 정보를 표시합니다."
                }, {
                    type: "name",
                    title: "상태",
                    content: "게스트 네트워크의 현재 상태 (설정 또는 해제)."
                }, {
                    type: "name",
                    title: "SSID",
                    content: "게스트 네트워크의 무선 네트워크 이름입니다."
                }
            ]
        },
        STATUS_USB: {
            TITLE: "USB 디바이스",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "USB 포트를 통해 라우터에 연결된 현재 USB 저장 장치 및 / 또는 프린터의 정보를 표시합니다"
                }, {
                    type: "name",
                    title: "프린터",
                    content: "연결된 프린터의 이름입니다."
                }, {
                    type: "name",
                    title: "합께",
                    content: "연결된 USB 저장 장치의 총 저장 용량입니다."
                }, {
                    type: "name",
                    title: "유효",
                    content: "연결된 USB 저장 장치의 사용 가능한 저장 용량입니다"
                }
            ]
        },
        STATUS_PERFORMANCE: {
            TITLE: "성능",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "현재 공유기 성능을 표시합니다."
                }, {
                    type: "name",
                    title: "CPU로드",
                    content: "현재 CPU 사용량입니다"
                }, {
                    type: "name",
                    title: "메모리 사용",
                    content: "현재 메모리 사용량입니다"
                }
            ]
        },
        STATUS_WIRED: {
            TITLE: "유선 클라이언트",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "현재 네트워크에 연결된 모든 유선 장치의 정보를 표시합니다."
                }
            ]
        },
        STATUS_WIRELESS_CLIENTS: {
            TITLE: "무선 클라이언트",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "무선 클라이언트 아이콘을 클릭하면 현재 파워라인 익스텐더로 구축 된 무선 네트워크에 연결된 모든 무선 장치의 정보를 표시합니다."
                }, {
                    type: "name",
                    title: "MAC 주소",
                    content: "무선 클라이언트의 MAC 주소입니다."
                }, {
                    type: "name",
                    title: "무선 밴드",
                    content: "클라이언트가 연결된 무선 대역 <span class=\"anti_5g\"> (2.4GHz 또는 5GHz) </span>."
                }
            ]
        },
        STATUS_WIFI_MOVE: {
            TITLE: "Wi-Fi 이동",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Wi-Fi 이동 기능의 사용 여부를 나타냅니다."
                }
            ]
        },
        INTERNET_INTERNET: {
            TITLE: "IPv4",
            CONTENT: [
                {
                    type: "title",
                    title: "인터넷 연결 유형 : 고정 IP"
                }, {
                    type: "paragraph",
                    content: "ISP가 특정 (고정) IP 주소, 서브넷 마스크, 게이트웨이 및 DNS 매개 변수를 제공 한 경우이 유형을 선택하십시오."
                }, {
                    type: "name",
                    title: "IP 주소 / 서브넷 마스크 / 기본 게이트웨이 / 기본 DNS / 보조 DNS",
                    content: "ISP가 제공 한 정보를 입력하십시오."
                }, {
                    type: "name",
                    title: "MTU 크기",
                    content: "대부분의 이더넷 네트워크의 기본 MTU (최대 전송 장치) 크기는 1500 바이트입니다. ISP가 요구하지 않는 한 기본 MTU 크기를 변경하지 않는 것이 좋습니다."
                }, {
                    type: "title",
                    title: "인터넷 연결 유형 : 동적 IP"
                }, {
                    type: "paragraph",
                    content: "ISP (Internet Service Provider)가 DHCP 서버 연결을 제공 받으면 이 유형을 선택하십시오."
                }, {
                    type: "name",
                    title: "IP 주소 / 서브넷 마스크 / 기본 게이트웨이 / 기본 DNS / 보조 DNS",
                    content: "이 매개 변수는 ISP의 DHCP 서버에 의해 자동으로 할당됩니다."
                }, {
                    type: "name",
                    title: "새로 고침",
                    content: "이 버튼을 클릭하면 DHCP 서버에서 새로운 IP 매개 변수를 가져올 수 있습니다."
                }, {
                    type: "name",
                    title: "해제",
                    content: "DHCP 서버가 할당 한 모든 IP 주소를 해제하려면 이 버튼을 누르십시오."
                }, {
                    type: "name",
                    title: "다음 DNS 주소 사용",
                    content: "ISP가 하나 또는 두 개의 DNS 주소를 제공하는 경우이 확인란을 선택하고 해당 입력 필드에 기본 DNS 및 보조 DNS 주소를 입력합니다. 그렇지 않으면 DNS 주소가 ISP에 의해 동적으로 할당됩니다."
                }, {
                    type: "name",
                    title: "MTU 크기",
                    content: "대부분의 이더넷 네트워크의 기본 MTU (최대 전송 장치) 크기는 1500 바이트입니다. ISP가 요구하지 않는 한 기본 MTU 크기를 변경하지 않는 것이 좋습니다."
                }, {
                    type: "name",
                    title: "호스트 이름",
                    content: "이 필드에 값을 입력하여 공유기의 호스트 이름을 지정하십시오."
                }, {
                    type: "name",
                    title: "유니 캐스트 DHCP를 사용하여 IP 가져 오기",
                    content: "ISP의 DHCP 서버가 브로드 캐스트 응용 프로그램을 지원하지 않고 IP 주소를 동적으로 가져올 수없는 경우이 확인란을 선택합니다.\\n"
                }, {
                    type: "note",
                    title: "비고",
                    content: "DNS 주소를 입력 한 후 \"주소를 찾을 수 없음\"오류가 발생하면 DNS 서버가 잘못 설정되었을 수 있습니다. 도움을 받으려면 ISP에 문의하십시오."
                }, {
                    type: "title",
                    title: "인터넷 연결 유형 : PPPoE"
                }, {
                    type: "paragraph",
                    content: "DSL (디지털 가입자 회선) 서비스를 사용하고 ISP가 제공 한 사용자 이름과 암호가있는 경우이 유형을 선택하십시오."
                }, {
                    type: "name",
                    title: "사용자 이름 / 암호",
                    content: "ISP가 제공 한 사용자 이름과 암호를 입력하십시오. 이 필드는 대소 문자를 구분합니다."
                }, {
                    type: "name",
                    title: "인터넷 IP 주소 / 기본 DNS / 보조 DNS",
                    content: "이 매개 변수는 ISP의 DHCP 서버에 의해 자동으로 할당됩니다."
                }, {
                    type: "name",
                    title: "보조 연결 (없음, 유동 IP, 고정 IP)",
                    children: [
                        {
                            type: "name",
                            title: "없음",
                            content: "보조 연결이 제공되지 않는 경우 선택하십시오."
                        }, {
                            type: "name",
                            title: "동적 IP",
                            content: "IP 주소 및 서브넷 마스크가 ISP에 의해 자동으로 할당되는 경우 선택하십시오.",
                            children: [
                                {
                                    type: "name",
                                    title: "새로 고침",
                                    content: "ISP의 IP 매개 변수를 갱신하려면 이 버튼을 누르십시오."
                                }, {
                                    type: "name",
                                    title: "해제",
                                    content: "할당 된 IP 매개 변수를 해제하려면이 단추를 클릭하십시오."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "고정 IP",
                            content: "ISP가 IP 주소, 서브넷 마스크, 게이트웨이 및 DNS 주소를 제공하는지 여부를 선택하고 해당 정보를 해당 필드에 입력하십시오."
                        }
                    ]
                }, {
                    type: "name",
                    title: "MTU 크기",
                    content: "이더넷 네트워크의 일반적인 MTU (최대 전송 단위) 크기는 1480 바이트입니다.",
                    children: [
                        {
                            type: "note",
                            title: "비고",
                            content: "드문 경우이지만 ISP가 네트워크 성능을 향상 시키려면 MTU 크기를 조정해야 할 수도 있습니다. 절대적으로 필요한 경우가 아니면 값을 변경해서는 안됩니다."
                        }
                    ]
                }, {
                    type: "name",
                    title: "서비스 이름 / 액세스 집중 장치 이름",
                    content: "기본적으로 서비스 이름 및 AC (Access Concentrator) 이름은 비워 둡니다. 이 필드는 ISP가 요구하지 않으면 구성하지 마세요."
                }, {
                    type: "name",
                    title: "온라인 간격 감지",
                    content: "공유기가 시간마다 Access Concentrator를 온라인으로 검색하는 시간 간격 값을 0에서 120 사이 (초)로 입력하십시오. 기본값은 0이며, 이는 탐지되지 않음을 의미합니다."
                }, {
                    type: "name",
                    title: "IP 주소\\n",
                    content: "ISP가 특정 (고정) IP 주소를 제공하는 경우 다음 IP 주소 사용을 선택하고 필드에 IP 주소를 입력하십시오. 그렇지 않으면 ISP에서 동적으로 가져 오기를 선택하여 서버에서 할당 한 IP 주소를 자동으로 얻습니다."
                }, {
                    type: "name",
                    title: "DNS 주소 / 기본 DNS / 보조 DNS",
                    content: "ISP가 특정 (고정) DNS IP 주소를 제공하면 다음 DNS 주소 사용을 선택하고 주 DNS 및 보조 DNS 필드에 각각 주소를 입력하십시오. 그렇지 않으면 ISP에서 동적으로 가져 오기를 선택하여 서버에서 할당 한 DNS IP 주소를 자동으로 가져옵니다.\\n"
                }, {
                    type: "name",
                    title: "연결 모드",
                    content: "인터넷에 연결하는 방법을 결정하는 적절한 연결 모드를 선택하십시오.",
                    children: [
                        {
                            type: "name",
                            title: "자동",
                            content: "이 모드에서는 인터넷 연결이 끊어지면 언제든지 자동으로 다시 연결됩니다."
                        }, {
                            type: "name",
                            title: "주문형",
                            content: "이 모드에서는 지정된 비활성 시간 (최대 유휴 시간)이 경과하면 인터넷 연결이 자동으로 종료됩니다. 인터넷에 다시 액세스하려고하면 연결이 다시 설정됩니다."
                        }, {
                            type: "name",
                            title: "시간 기반",
                            content: "이 모드에서는 인터넷 연결이 특정 시간대에만 설정됩니다. 이 옵션을 선택한 경우 시작 시간과 종료 시간을 입력하십시오. 둘 다 HH : MM 형식입니다."
                        }, {
                            type: "name",
                            title: "\n\\n수동으로",
                            content: "이 모드에서는 인터넷 연결이 연결 또는 연결 끊기 단추를 클릭하여 수동으로 제어됩니다. 이 모드는 최대 유휴 시간 기능도 지원합니다. 최대 유휴 시간 필드에 인터넷 연결이 종료되기 전에 인터넷 연결이 비활성화 될 수있는 최대 시간 (분)을 입력하십시오. 기본값은 15 분입니다. 인터넷 연결을 항상 활성 상태로 유지하려면 0을 입력하십시오."
                        }, {
                            type: "note",
                            title: "참고",
                            content: "시간 기반 연결 모드는 고급 → 시스템 도구 → 시간 설정 페이지의 시스템 시간이 구성된 후에 만 ​​적용됩니다."
                        }
                    ]
                }, {
                    type: "title",
                    title: "인터넷 연결 유형 : BigPond Cable"
                }, {
                    type: "paragraph",
                    content: "ISP가 BigPond 케이블 연결을 제공하는 경우이 유형을 선택하십시오."
                }, {
                    type: "name",
                    title: "사용자 이름 / 암호",
                    content: "ISP가 제공 한 사용자 이름과 암호를 입력하십시오. 이 필드는 대소 문자를 구분합니다."
                }, {
                    type: "name",
                    title: "Auth. Server",
                    content: "인증 서버의 IP 주소 또는 호스트 이름을 입력하십시오."
                }, {
                    type: "name",
                    title: "Auth.도메인",
                    content: "사용자의 위치에 따라 서버의 도메인 이름 접미사를 입력하십시오. 예 : NSW / ACT의 경우 nsw.bigpond.net.au, VIC / TAS / WA / SA / NT의 경우 vic.bigpond.net.au 또는 QLD의 경우 qld.bigpond.net.au."
                }, {
                    type: "name",
                    title: "MTU 크기",
                    content: "대부분의 이더넷 네트워크의 기본 MTU (최대 전송 장치) 크기는 1500 바이트입니다. ISP가 요구하지 않는 한 기본 MTU 크기를 변경하지 않는 것이 좋습니다."
                }, {
                    type: "name",
                    title: "연결 모드",
                    content: "인터넷에 연결하는 방법을 결정하는 적절한 연결 모드를 선택하십시오.",
                    children: [
                        {
                            type: "name",
                            title: "자동",
                            content: "이 모드에서는 인터넷 연결이 끊어지면 언제든지 자동으로 다시 연결됩니다."
                        }, {
                            type: "name",
                            title: "주문형",
                            content: "이 모드에서는 지정된 비활성 시간 (최대 유휴 시간)이 경과하면 인터넷 연결이 자동으로 종료됩니다. 인터넷에 다시 액세스하려고하면 연결이 다시 설정됩니다."
                        }, {
                            type: "name",
                            title: "수동",
                            content: "이 모드에서는 인터넷 연결이 연결 또는 연결 끊기 단추를 클릭하여 수동으로 제어됩니다. 이 모드는 최대 유휴 시간 기능도 지원합니다. 최대 유휴 시간 필드에 인터넷 연결이 종료되기 전에 인터넷 연결이 비활성화 될 수있는 최대 시간 (분)을 입력하십시오. 기본값은 15 분입니다. 인터넷 연결을 항상 활성 상태로 유지하려면 0을 입력하십시오."
                        }
                    ]
                }, {
                    type: "title",
                    title: "인터넷 연결 유형 : L2TP / PPTP"
                }, {
                    type: "paragraph",
                    content: "L2TP / PPTP VPN 서버에 연결하고 ISP가 서버의 사용자 이름, 암호 및 IP 주소 / 도메인 이름을 제공하는 경우이 유형을 선택하십시오."
                }, {
                    type: "name",
                    title: "사용자 이름 / 암호",
                    content: "ISP가 제공 한 사용자 이름과 암호를 입력하십시오. 이 필드는 대소 문자를 구분합니다."
                }, {
                    type: "name",
                    title: "인터넷 IP 주소 / 기본 DNS / 보조 DNS",
                    content: "이 매개 변수는 ISP의 DHCP 서버에 의해 자동으로 할당됩니다."
                }, {
                    type: "name",
                    title: "보조 연결 (유동 IP 또는 고정 IP)",
                    children: [
                        {
                            type: "name",
                            title: "동적 IP",
                            content: "IP 주소 및 서브넷 마스크가 ISP에 의해 자동으로 할당되는 경우 선택하십시오.",
                            children: [
                                {
                                    type: "name",
                                    title: "새로 고침",
                                    content: "ISP의 IP 매개 변수를 갱신하려면 이 버튼을 누르십시오."
                                }, {
                                    type: "name",
                                    title: "해제",
                                    content: "할당 된 IP 매개 변수를 해제하려면이 단추를 클릭하십시오."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "고정 IP",
                            content: "ISP가 IP 주소, 서브넷 마스크, 게이트웨이 및 DNS 주소를 제공하는지 여부를 선택하고 해당 정보를 해당 필드에 입력하십시오."
                        }
                    ]
                }, {
                    type: "name",
                    title: "VPN 서버 IP / 도메인 이름",
                    content: "ISP가 제공 한 VPN 서버의 IP 주소 또는 도메인 이름을 입력하십시오."
                }, {
                    type: "name",
                    title: "MTU 크기",
                    content: "대부분의 이더넷 네트워크의 기본 MTU (최대 전송 단위) 크기는 1460 바이트입니다. ISP가 요구하지 않는 한 기본 MTU 크기를 변경하지 않는 것이 좋습니다."
                }, {
                    type: "name",
                    title: "연결 모드",
                    content: "인터넷에 연결하는 방법을 결정하는 적절한 연결 모드를 선택하십시오.",
                    children: [
                        {
                            type: "name",
                            title: "자동",
                            content: "이 모드에서는 인터넷 연결이 끊어지면 언제든지 자동으로 다시 연결됩니다."
                        }, {
                            type: "name",
                            title: "주문형",
                            content: "이 모드에서는 지정된 비활성 시간 (최대 유휴 시간)이 경과하면 인터넷 연결이 자동으로 종료됩니다. 인터넷에 다시 액세스하려고하면 연결이 다시 설정됩니다."
                        }, {
                            type: "name",
                            title: "수동",
                            content: "이 모드에서는 인터넷 연결이 연결 또는 연결 끊기 단추를 클릭하여 수동으로 제어됩니다. 이 모드는 최대 유휴 시간 기능도 지원합니다. 최대 유휴 시간 필드에 인터넷 연결이 종료되기 전에 인터넷 연결이 비활성화 될 수있는 최대 시간 (분)을 입력하십시오. 기본값은 15 분입니다. 인터넷 연결을 항상 활성 상태로 유지하려면 0을 입력하십시오."
                        }
                    ]
                }
            ]
        },
        HELP_PLC_STATION: {
            TITLE: "파워라인 디바이스 리스트",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "동일한 전기 회로에있는 동일한 네트워크에 속하는 모든 파워라인 장치의 정보를 표시합니다."
                }, {
                    type: "name",
                    title: "로컬 디바이스",
                    content: "현재 로그인 한 파워라인 익스텐더입니다."
                }, {
                    type: "step",
                    content: ["파워라인 장치 목록에서 해당 장치의 MAC 주소 및 데이터 전송률이 왼쪽에서 오른쪽으로 표시됩니다.", "<b> 휴지통 </b> 아이콘을 클릭하면이 네트워크에서 해당 전력선을 제거 할 수 있습니다.", "<b> 플러스 </b> 아이콘을 클릭하면 파워 라인 네트워크에 새로운 파워 라인 익스텐더를 추가 할 수 있습니다."]
                }, {
                    type: "name",
                    title: "뒤로",
                    content: "Status (상태) 페이지로 돌아가려면 클릭하십시오."
                }, {
                    type: "name",
                    title: "새로 고침",
                    content: "페이지를 새로 고치려면 클릭하십시오."
                }
            ]
        },
        INTERNET_MAC: {
            TITLE: "MAC 클론",
            CONTENT: [
                {
                    type: "name",
                    title: "기본 MAC 주소 사용",
                    content: "ISP가 할당 된 IP 주소를 MAC 주소에 바인딩하지 않는 경우 공유기의 기본 MAC 주소를 변경하지 마십시오."
                }, {
                    type: "name",
                    title: "현재 컴퓨터 MAC 주소 사용",
                    content: "ISP가 할당 된 IP 주소를 컴퓨터의 MAC 주소에 바인드 할 경우 공유기에 연결된 컴퓨터의 현재 MAC 주소를 복사하려면 선택합니다."
                }, {
                    type: "name",
                    title: "사용자 지정 MAC 주소 사용",
                    content: "ISP가 할당 된 IP 주소를 특정 MAC 주소에 바인딩하는 경우 MAC 주소를 수동으로 입력하십시오."
                }
            ]
        },
        LAN_IPV4: {
            TITLE: "LAN 설정",
            CONTENT: [
                {
                    type: "name",
                    title: "LAN 타입",
                    content: "동적 IP 혹은 고정 IP 선택하세요"
                }, {
                    type: "name",
                    title: "동적 IP",
                    content: "DHCP 서버에서 IP 주소를 자동으로 받으려면 이 옵션을 선택하십시오."
                }, {
                    type: "name",
                    title: "고정 IP",
                    content: "IP 주소, 서브넷 마스크 및 기본 게이트웨이를 수동으로 지정하려면 이 옵션을 선택합니다."
                }, {
                    type: "name",
                    title: "IP 주소",
                    content: "익스텐더의 웹 관리 페이지에 로그인하는 데 사용되며 무시할 수있는 기본 익스텐더의 IP 주소를 표시합니다."
                }, {
                    type: "name",
                    title: "서브넷 마스크",
                    content: "드롭 다운 목록에서 내부 및 외부 트래픽을 라우팅하거나 점으로 구분 된 10 진수 형식으로 새 서브넷 마스크를 입력하려면 LAN 포트에서 사용하는 할당 된 식별자를 선택하십시오"
                }, {
                    type: "name",
                    title: "기본 게이트웨이",
                    content: "익스텐더를 네트워크에 연결하는 데 사용되는 IP 주소입니다."
                }, {
                    type: "paragraph",
                    content: "<b> 저장 </b>을 클릭하여 모든 설정을 저장하십시오."
                }
            ]
        },
        LED_TIME: {
            TITLE: "LED 스케줄",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "LED 일정을 사용하면 특정 시간 일정에 따라이 전력선 익스텐더의 LED를 켜거나 끌 수 있습니다."
                }, {
                    type: "name",
                    title: "LED 스케쥴러",
                    content: "LED 스케줄러 기능을 사용하려면 <b> 켜기 </b>로 전환하십시오."
                }
            ]
        },
        LED_TIME_GRID: {
            TITLE: "LED 끄기 일정",
            CONTENT: [
                {
                    type: "name",
                    title: "에서",
                    content: "LED가 꺼져있는 시간을 표시합니다."
                }, {
                    type: "name",
                    title: "에",
                    content: "LED가 다시 켜지는 시간을 표시합니다."
                }, {
                    type: "name",
                    title: "일",
                    content: "일정의 유효일을 표시합니다."
                }, {
                    type: "name",
                    title: "상태",
                    content: "해당 일정의 현재 상태를 나타냅니다. 일정을 사용 또는 사용 중지하려면 <b> 벌브 </b> 아이콘을 클릭하십시오."
                }, {
                    type: "name",
                    title: "수정",
                    content: "해당 일정을 <b> 수정 </b> 또는 <b> 삭제 </b> 할 수있는 옵션을 표시합니다."
                }, {
                    type: "step",
                    title: "새 일정을 만듭니다",
                    content: ["1. <b> 추가 </b>를 클릭하십시오.", "2. LED가 꺼지는 시간 범위를 지정하십시오.", "3.이 일정이 유효한 요일을 선택하십시오.", "4. <b>이 항목 사용 </b>을 선택하십시오.", "5. <b> 확인 </b>을 클릭하여 설정을 저장하십시오."]
                }, {
                    type: "paragraph",
                    content: "일정을 수정하거나 삭제하려면 <b> 수정 </b> 아이콘을 클릭하여 정보를 수정하거나 <b> 휴지통 </b> 아이콘을 클릭하여 해당 일정을 삭제하십시오."
                }, {
                    type: "paragraph",
                    content: "여러 개의 일정을 삭제하려면 삭제할 일정의 해당 확인란을 선택하고 표 위에서 <b> 삭제 </b>를 클릭하십시오."
                }
            ]
        },
        HELP_PLC: {
            TITLE: "파워라인",
            CONTENT: [
                {
                    type: "name",
                    title: "MAC 주소",
                    content: "파워라인 장치에 할당 된 고유 한 물리적 주소입니다"
                }, {
                    type: "name",
                    title: "파워라인 키",
                    content: "파워라인 네트워크에 추가 될 때 사용되는이 파워라인 장치의 고유 키이며  암호는 제품 라벨에도 표시되어 있습니다."
                }, {
                    type: "name",
                    title: "네트워크 이름",
                    content: "파워라인 익스텐더가 속한 파워라인 네트워크 이름을 표시합니다. 여기에서 네트워크의 이름을 변경하거나 기본값을 클릭하여 공장 기본 이름 (예 : HomePlugAV)으로 재설정 할 수 있습니다. 공장 기본 이름을 사용하는 경우 Wi-Fi 이동 기능이 자동으로 비활성화됩니다."
                }
            ]
        },
        IPTV: {
            TITLE: "설정",
            CONTENT: [
                {
                    type: "name",
                    title: "IPTV",
                    content: "IPTV 기능을 활성화하려면 선택하십시오."
                }, {
                    type: "name",
                    title: "모드",
                    content: "ISP에 따라 적절한 모드를 선택하십시오. 지원되는 IPTV 모드는 6 가지입니다.",
                    children: [
                        {
                            type: "name",
                            title: "브릿지",
                            content: "ISP가 표시되지 않고 다른 매개 변수가 필요하지 않은 경우 이 모드를 선택하고 라우터의 LAN 포트 기능을 구성하기만 하면 됩니다.",
                            children: [
                                {
                                    type: "name",
                                    title: "LAN 1/2/3/4",
                                    content: "LAN 포트를 인터넷 공급 업체 또는 IPTV 공급 업체로 사용할 지 지정하십시오."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "러시아",
                            content: "ISP가 러시아의 경우에는 인터넷 / IP 전화 / IPTV VLAN ID 및 우선 순위, LAN (1/2/3/4) 포트 기능을 포함하여 필요한 매개 변수가 미리 결정된 경우 선택하십시오.",
                            children: [
                                {
                                    type: "name",
                                    title: "IPTV 멀티 캐스트 VLAN ID / 우선 순위",
                                    content: "원하는대로 IPTV 멀티 캐스트 기능을 활성화하고 ISP에 따라 VLAN ID 및 우선 순위를 구성 할 수 있습니다."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "싱가포르 - ExStream",
                            content: "ISP가 싱가포르의 ExStream이며 인터넷 / IPTV VLAN ID 및 우선 순위, LAN (1/2/3/4) 포트 기능을 포함하여 필요한 매개 변수가 미리 결정된 경우 선택하십시오."
                        }, {
                            type: "name",
                            title: "말레이시아 - Unifi",
                            content: "ISP가 말레이시아의 Unifi이고 인터넷 / IPTV VLAN ID 및 우선 순위, LAN (1/2/3/4) 포트 기능을 포함하여 필요한 매개 변수가 미리 결정된 경우 선택하십시오."
                        }, {
                            type: "name",
                            title: "말레이시아 - Maxis",
                            content: "ISP가 말레이시아의 Maxis이고 인터넷 / IP 전화 / IPTV VLAN ID 및 우선 순위, LAN (1/2/3/4) 포트 기능을 포함하여 필요한 매개 변수가 미리 결정된 경우 선택하십시오."
                        }, {
                            type: "name",
                            title: "커스텀",
                            content: "ISP가 목록에 없지만 인터넷 / IP 전화 / IPTV VLAN ID 및 우선 순위 및 LAN (1/2/3/4) 포트 기능을 포함하여 필요한 매개 변수를 제공하는 경우 선택하십시오.",
                            children: [
                                {
                                    type: "name",
                                    title: "인터넷 / IP 전화 / IPTV VLAN ID / 우선 순위",
                                    content: "ISP가 제공 한 VLAN ID를 구성하십시오."
                                }, {
                                    type: "name",
                                    title: "802.11Q Tag",
                                    content: "인터넷 패킷에 802.11Q를 태그할지 여부를 선택하십시오."
                                }, {
                                    type: "name",
                                    title: "IPTV 멀티 캐스트 VLAN ID / 우선 순위",
                                    content: "원하는대로 IPTV 멀티 캐스트 기능을 활성화하고 ISP에 따라 VLAN ID 및 우선 순위를 구성 할 수 있습니다."
                                }, {
                                    type: "name",
                                    title: "LAN 1/2/3/4",
                                    content: "인터넷 공급 업체 또는 IPTV 공급 업체로서 LAN 포트를 할당하십시오."
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "IGMP Proxy",
                    content: "ISP에 따라 IGMP (인터넷 그룹 관리 프로토콜) 프록시 버전 (V2 또는 V3)을 선택합니다."
                }
            ]
        },
        DHCP_SERVER_SETTINGS: {
            TITLE: "설정",
            CONTENT: [
                {
                    type: "name",
                    title: "DHCP 서버",
                    content: "기본적으로 DHCP (동적 호스트 구성 프로토콜) 서버는 사용 가능합니다. IP 주소 풀에서 클라이언트 장치에 TCP / IP 매개 변수를 동적으로 할당합니다. 다른 DHCP 서버가 있거나 네트워크의 모든 클라이언트 장치에 TCP / IP 매개 변수를 수동으로 할당하려는 경우가 아니면 DHCP 서버를 비활성화하지 마십시오."
                }, {
                    type: "name",
                    title: "IP 주소 영역",
                    content: "클라이언트에 임대 할 수있는 IP 주소의 범위를 입력하십시오."
                }, {
                    type: "name",
                    title: "주소 임대 시간",
                    content: "IP 주소가 클라이언트에 2 분에서 2880 분 사이에 임대되는 기간을 입력하십시오. 기본값은 120 분입니다."
                }, {
                    type: "name",
                    title: "기본 게이트웨이",
                    content: "LAN IP 주소를 입력하십시오. (선택 사항)"
                }, {
                    type: "name",
                    title: "기본 DNS / 보조 DNS",
                    content: "ISP가 제공 한대로이 매개 변수를 입력하십시오. (선택 사항)"
                }
            ]
        },
        RESERVED_IP_ADDRESS: {
            TITLE: "주소 예약",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "공유기에 연결된 클라이언트의 IP 주소를 수동으로 예약 할 수 있습니다. 일단 예약되면 IP 주소는 DHCP 서버에 의해서만 동일한 클라이언트에 할당됩니다."
                }, {
                    type: "name",
                    title: "MAC 주소",
                    content: "DHCP 예약 IP 주소를 가진 클라이언트의 MAC 주소를 표시합니다."
                }, {
                    type: "name",
                    title: "예약 된 IP 주소",
                    content: "클라이언트의 예약 된 IP 주소를 표시합니다."
                }, {
                    type: "name",
                    title: "설명",
                    content: "클라이언트 장치에 대한 설명을 표시합니다."
                }, {
                    type: "name",
                    title: "상태",
                    content: "클라이언트 장치의 현재 상태 (활성화 또는 비활성화)를 표시합니다."
                }, {
                    type: "name",
                    title: "수정",
                    content: "해당 클라이언트 수정 또는 삭제 옵션을 표시합니다."
                }, {
                    type: "step",
                    title: "IP 주소를 예약합니다",
                    content: [
                        "1. 추가를 클릭하십시오.",
                        "2. 원하는 클라이언트의 MAC 주소를 입력하십시오.\"",
                        "3. 클라이언트에 예약하려는 IP 주소를 입력하십시오.\"",
                        "4. 클라이언트에 대한 설명을 입력하십시오",
                        "5. 사용을 선택하십시오.",
                        "6. 확인을 클릭하십시오."
                    ]
                }, {
                    type: "step",
                    title: "기존 클라이언트를 수정하거나 삭제합니다",
                    content: "표에서 수정 또는 삭제할 클라이언트에 해당하는 편집 아이콘 또는 삭제 아이콘을 클릭하십시오."
                }
            ]
        },
        DHCP_CLIENT_LIST: {
            TITLE: "DHCP 클라이언트 목록",
            CONTENT: [
                {
                    type: "name",
                    title: "클라이언트 번호",
                    content: "연결된 DHCP 클라이언트의 번호를 표시합니다."
                }, {
                    type: "name",
                    title: "클라이언트 이름",
                    content: "DHCP 클라이언트의 이름을 표시합니다."
                }, {
                    type: "name",
                    title: "MAC 주소",
                    content: "MAC 주소를 표시합니다."
                }, {
                    type: "name",
                    title: "할당 된 IP 주소",
                    content: "할당 된 IP 주소를 DHCP 서버가 클라이언트에 표시합니다."
                }, {
                    type: "name",
                    title: "임대 시간",
                    content: "클라이언트에 임대 된 IP 주소의 지속 시간을 표시합니다."
                }, {
                    type: "name",
                    title: "새로 고침",
                    content: "DHCP 클라이언트 목록을 업데이트하려면 클릭하십시오."
                }
            ]
        },
        DDNS: {
            TITLE: "동적 DNS",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "동적 DNS를 사용하면 고정 된 호스트 및 도메인 이름을 동적 인터넷 IP 주소에 할당 할 수 있습니다. 자신의 웹 사이트, FTP 서버 또는 라우터 뒤의 다른 서버를 호스팅 할 때 유용합니다. 먼저 www.dyndns.com과 같은 DDNS 서비스 제공 업체에 가입해야합니다."
                }, {
                    type: "step",
                    title: "동적 DNS를 설정합니다",
                    content: ["1. DDNS 서비스 제공자를 선택하십시오.", "2. DDNS 계정의 사용자 이름과 암호를 입력하십시오.", "3. DDNS 서비스 공급자로부터받은 도메인 이름을 입력하십시오.", "4. 드롭 다운 목록에서 업데이트 간격을 선택하십시오.", "5. 로그인 및 저장을 클릭하십시오."]
                }, {
                    type: "paragraph",
                    content: "계정을 전환하려면 먼저 현재 계정을 로그 아웃 한 다음 새 사용자 이름과 암호로 다른 계정을 로그인해야합니다."
                }
            ]
        },
        ADVANCED_ROUTING_STATIC_ROUTING: {
            TITLE: "고정 라우팅",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "고정 라우팅은 네트워크 정보 패킷이 특정 호스트 나 네트워크에 도달하는 고정 경로를 미리 결정하는 데 사용됩니다."
                }, {
                    type: "step",
                    title: "고정 라우팅을 설정합니다",
                    content: [
                        "1. 추가를 클릭하십시오.",
                        "2. 대상 네트워크 -이 항목에 고정 경로를 할당 할 IP 주소를 16 진수로 입력하십시오.",
                        "3. 서브넷 마스크 - 서브넷 마스크를 16 진수 형식으로 입력하여 IP 주소의 네트워크 부분과 호스트 부분을 결정합니다.",
                        "4. 기본 게이트웨이 - 라우터를 네트워크 또는 호스트에 연결하기위한 16 진수 형식의 게이트웨이 IP 주소를 입력합니다.",
                        "5. 인터페이스 - LAN 또는 WAN을 선택하여 대상 네트워크의 유형을 지정하십시오.",
                        "6. 설명 -이 항목에 대한 간단한 설명을 입력하십시오.",
                        "5. 사용을 선택하십시오.",
                        "6. 확인을 클릭하십시오."
                    ]
                }, {
                    type: "step",
                    title: "기존 항목을 수정하거나 삭제합니다",
                    content: "표에서 수정 또는 삭제할 클라이언트에 해당하는 편집 아이콘 또는 삭제 아이콘을 클릭하십시오."
                }
            ]
        },
        ADVANCED_ROUTING_SYSTEM_ROUTING: {
            TITLE: "시스템 라우팅 테이블",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "시스템 라우팅 테이블은 현재 사용중인 모든 유효한 경로 항목을 표시합니다."
                }, {
                    type: "paragraph",
                    content: "새로 고침을 클릭하여 라우팅 테이블을 업데이트합니다."
                }
            ]
        },
        WIRELESS_REGION: {
            TITLE: "설정",
            CONTENT: [
                {
                    type: "name",
                    title: "지역",
                    content: "드롭 다운 메뉴에서 해당 지역을 선택하십시오. 해당 국가 또는 지역이 목록에없는 경우 해당 지역의 무선 라디오를 사용하도록 제한 될 수 있습니다."
                }, {
                    type: "paragraph",
                    content: "<b> 저장 </b>을 클릭하여 모든 설정을 저장하십시오."
                }
            ]
        },
        WIRELESS_BOTH: {
            TITLE: "무선",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "아래 지침은 <span class=\"anti_5g\"> 2.4GHz 및 5GHz 모두 </span> 무선 네트워크에 대한 것입니다."
                }, {
                    type: "name",
                    title: "무선 라디오 사용",
                    content: "무선 라디오 주파수를 활성화하려면이 확인란을 선택합니다."
                }, {
                    type: "name",
                    title: "네트워크 이름 (SSID)",
                    content: "기본 네트워크 이름 (SSID)은 그대로 두거나 새 이름을 만들 수 있습니다 (최대 32 자). 이 필드는 대소 문자를 구분합니다."
                }, {
                    type: "name",
                    title: "SSID 숨기기",
                    content: "Wi-Fi 네트워크 목록에서 해당 네트워크 이름 (SSID)을 숨기려면이 확인란을 선택합니다."
                }, {
                    type: "name",
                    title: "암호",
                    content: "이 무선 네트워크를 보호하려면 8 ~ 63 자의 ASCII 문자 또는 8 ~ 64 자의 16 진수 문자 사이에 무선 암호를 만드십시오."
                }, {
                    type: "name",
                    title: "고급",
                    content: "고급 설정을 표시하려면 클릭하십시오."
                }, {
                    type: "name",
                    title: "보안",
                    content: "다음 보안 옵션 중 하나를 선택하십시오.",
                    children: [
                        {
                            type: "name",
                            title: "보안 없음",
                            content: "무선 보안을 사용하지 않으려면 이 옵션을 선택하십시오. 무단 액세스로부터 무선 네트워크를 보호하기 위해 무선 보안을 활성화하는 것이 <b> 강력하게 권장 </b>됩니다."
                        }, {
                            type: "name",
                            title: "WPA / WPA2- 개인",
                            content: "암호문이라고도하는 PSK (Pre-shared Key)를 기반으로 표준 인증 방법을 사용하려면이 옵션을 선택합니다. 이 옵션을 사용하는 것이 좋습니다. 선택하는 경우 다음을 구성하십시오.",
                            children: [
                                {
                                    type: "name",
                                    title: "버전",
                                    content: "무선 네트워크에 대한 보안 버전을 선택하십시오.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "자동",
                                            content: "이 옵션은 WPA 및 WPA2와 같은 WPA (Wi-Fi Protected Access) 표준의 다중 구현을 지원합니다."
                                        }, {
                                            type: "name",
                                            title: "WPA-PSK",
                                            content: "이 옵션은 TKIP 및 AES 암호화를 지원합니다."
                                        }, {
                                            type: "name",
                                            title: "WPA2-PSK",
                                            content: "이 옵션은 WPA-PSK보다 우수한 보안 수준을 제공하며 권장됩니다."
                                        }
                                    ]
                                }, {
                                    type: "name",
                                    title: "암호화",
                                    content: "보안 암호화 유형을 <b> TKIP </b> (임시 키 무결성 프로토콜), <b> AES </b> (고급 암호화 표준) 또는 <b> 자동 </b> (TKIP 및 AES ). TKIP가 802.11n 사양에서 지원되지 않기 때문에 powerline 익스텐더가 802.11n 모드에서 작동하는 경우 TKIP 암호화를 사용하는 것이 <b> NOT </b>됩니다."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "WEP",
                            content: "클라이언트 장치 중 하나가 WEP (Wired Equivalent Privacy)를 사용하여 무선에만 액세스 할 수있는 경우 기본 인증 방법을 사용하려면이 옵션을 선택합니다.",
                            children: [
                                {
                                    type: "name",
                                    title: "타입",
                                    content: "무선 네트워크에 대한 인증 유형을 선택하십시오. 기본값은 무선 클라이언트의 기능 및 액세스 요청에 따라 <b> 시스템 열기 </b> 또는 <b> 공유 키 </b>를 자동으로 선택하는 <b> 자동 </b>입니다."
                                }, {
                                    type: "name",
                                    title: "선택한 키",
                                    content: "네 개의 키 중 하나를 선택하십시오."
                                }, {
                                    type: "name",
                                    title: "WEP 키 형식",
                                    content: "<b> ASCII </b> 또는 <b> 16 진수 </b> 형식을 사용하십시오. ASCII 형식은 영문자와 숫자의 조합입니다. 16 진수 형식은 숫자 (0-9)와 문자 (A-F, a-f)의 조합입니다."
                                }, {
                                    type: "name",
                                    title: "키 타입",
                                    content: "WEP 키 길이를 선택하십시오.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "64-bit",
                                            content: "암호 필드에 10 개의 16 진수 (0-9, A-F, a-f) 또는 5 개의 ASCII 문자를 입력 할 수 있습니다."
                                        }, {
                                            type: "name",
                                            title: "128-bit",
                                            content: "암호 필드에 26 개의 16 진수 (0-9, A-F, a-f) 또는 13 ASCII 문자를 입력 할 수 있습니다."
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "모드",
                    content: "전송 혼합 모드를 선택하십시오."
                }, {
                    type: "name",
                    title: "대역 폭",
                    content: "해당 무선 네트워크의 대역폭를 선택하십시오."
                }, {
                    type: "name",
                    title: "대역",
                    content: "대응하는 무선 네트워크에 작동하는 채널을 선택해 주십시오. 무선 인터넷 접속에 문제가 없는 경우 <b>자동</b>으로 두는 것이 권장됩니다."
                }, {
                    type: "name",
                    title: "송신 전력",
                    content: "데이터 전송 전원을 지정하려면 <b> 높음 </b>, <b> 중간 </b> 또는 <b> 낮음 </b>을 선택하십시오. 기본 설정 및 권장 설정은 <b> 높음 </b>입니다."
                }, {
                    type: "paragraph",
                    content: "<b> 저장 </b>을 클릭하여 모든 설정을 저장하십시오."
                }
            ]
        },
        WIRELESS_24G: {
            TITLE: "무선 2.4GHz",
            CONTENT: [
                {
                    type: "name",
                    title: "무선 라디오 사용",
                    content: "2.4GHz 무선 주파수를 활성화하려면이 확인란을 선택합니다."
                }, {
                    type: "name",
                    title: "네트워크 이름 (SSID)",
                    content: "기본 네트워크 이름 (SSID)은 그대로 두거나 새 이름을 입력 할 수 있습니다 (최대 32 자). 이 필드는 대소 문자를 구분합니다."
                }, {
                    type: "name",
                    title: "SSID 숨기기",
                    content: "Wi-Fi 네트워크 목록에서 2.4GHz 네트워크 이름 (SSID)을 숨기려면이 확인란을 선택합니다."
                }, {
                    type: "name",
                    title: "암호",
                    content: "이 무선 네트워크를 보호하려면 8 ~ 63 자의 ASCII 문자 또는 8 ~ 64 자의 16 진수 문자 사이에 무선 암호를 만드십시오."
                }, {
                    type: "name",
                    title: "고급",
                    content: "고급 설정을 표시하려면 클릭하십시오"
                }, {
                    type: "name",
                    title: "보안",
                    content: "다음 보안 옵션 중 하나를 선택하십시오.",
                    children: [
                        {
                            type: "name",
                            title: "보안 없음",
                            content: "무선 보안을 사용하지 않으려면 이 옵션을 선택하십시오. 무단 액세스로부터 무선 네트워크를 보호하기 위해 무선 보안을 활성화하는 것이 <b> 강력하게 권장 </b>됩니다."
                        }, {
                            type: "name",
                            title: "WPA / WPA2- 개인",
                            content: "PSK (Pre-shared Key)를 기반으로 표준 인증 방법을 사용하려면 이 옵션을 선택합니다. 이 옵션을 사용하는 것이 좋습니다. 선택하는 경우 다음을 구성하십시오.",
                            children: [
                                {
                                    type: "name",
                                    title: "버전",
                                    content: "무선 네트워크에 대한 보안 버전을 선택하십시오.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "자동",
                                            content: "이 옵션은 WPA 및 WPA2와 같은 WPA (Wi-Fi Protected Access) 표준의 다중 구현을 지원합니다."
                                        }, {
                                            type: "name",
                                            title: "WPA-PSK",
                                            content: "이 옵션은 TKIP 및 AES 암호화를 지원합니다."
                                        }, {
                                            type: "name",
                                            title: "WPA2-PSK",
                                            content: "이 옵션은 WPA-PSK보다 향상된 보안 수준을 제공하는 AES 암호화를 지원하며 권장됩니다."
                                        }
                                    ]
                                }, {
                                    type: "name",
                                    title: "암호화",
                                    content: "보안 암호화 유형을 <b> TKIP </b> (임시 키 무결성 프로토콜), <b> AES </b> (고급 암호화 표준) 또는 <b> 자동 </b> (TKIP 및 AES ). TKIP가 802.11n 사양에서 지원되지 않기 때문에 powerline 익스텐더가 802.11n 모드에서 작동하는 경우 TKIP 암호화를 사용하는 것이 <b> NOT </b>됩니다."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "WEP",
                            content: "클라이언트 장치 중 하나가 WEP (Wired Equivalent Privacy)를 사용하여 무선에만 액세스 할 수있는 경우 기본 인증 방법을 사용하려면  이 옵션을 선택합니다.",
                            children: [
                                {
                                    type: "name",
                                    title: "타입",
                                    content: "무선 네트워크에 대한 인증 유형을 선택하십시오. 기본값은 무선 클라이언트의 기능 및 액세스 요청에 따라 <b> 시스템 열기 </b> 또는 <b> 공유 키 </b>를 자동으로 선택하는 <b> 자동 </b>입니다."
                                }, {
                                    type: "name",
                                    title: "선택한 키",
                                    content: "네 개의 키 중 하나를 선택하십시오."
                                }, {
                                    type: "name",
                                    title: "WEP 키 형식",
                                    content: "ASCII 또는 16 진수 형식을 사용하십시오. ASCII 형식은 영문자와 숫자의 조합입니다. 16 진수 형식은 숫자 (0-9)와 문자 (A-F, a-f)의 조합입니다."
                                }, {
                                    type: "name",
                                    title: "키 타입",
                                    content: "WEP 키 길이를 선택하십시오.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "64-bit",
                                            content: "암호 필드에 10 개의 16 진수 (0-9, A-F, a-f) 또는 5 개의 ASCII 문자를 입력 할 수 있습니다."
                                        }, {
                                            type: "name",
                                            title: "128-bit",
                                            content: "암호 필드에 26 개의 16 진수 (0-9, A-F, a-f) 또는 13 ASCII 문자를 입력 할 수 있습니다."
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "모드",
                    content: "전송 혼합 모드를 선택하십시오."
                }, {
                    type: "name",
                    title: "대역 폭",
                    content: "2.4GHz 무선 네트워크의 채널 너비 (대역폭)를 선택하십시오"
                }, {
                    type: "name",
                    title: "대역",
                    content: "2.4GHz 무선 네트워크의 작동 채널을 선택하십시오. 간헐적인 무선 연결 문제가없는 경우 채널을 <b> 자동 </b>으로 설정하는 것이 좋습니다."
                }, {
                    type: "name",
                    title: "송신 전력",
                    content: "데이터 전송 전원을 지정하려면 <b> 높음 </b>, <b> 중간 </b> 또는 <b> 낮음 </b>을 선택하십시오. 기본 설정 및 권장 설정은 <b> 높음 </b>입니다."
                }
            ]
        },
        WIRELESS_5G: {
            TITLE: "무선 5GHz",
            CONTENT: [
                {
                    type: "name",
                    title: "무선 라디오 사용",
                    content: "5GHz 무선 주파수를 활성화하려면이 확인란을 선택합니다."
                }, {
                    type: "name",
                    title: "네트워크 이름 (SSID)",
                    content: "기본 네트워크 이름 (SSID)은 그대로 두거나 새 이름을 만들 수 있습니다 (최대 32 자). 이 필드는 대소 문자를 구분합니다."
                }, {
                    type: "name",
                    title: "SSID 숨기기",
                    content: "Wi-Fi 네트워크 목록에서 5GHz 네트워크 이름 (SSID)을 숨기려면이 확인란을 선택하십시오."
                }, {
                    type: "name",
                    title: "암호",
                    content: "이 무선 네트워크를 보호하려면 8 ~ 63 자의 ASCII 문자 또는 8 ~ 64 자의 16 진수 문자 사이에 무선 암호를 만드십시오."
                }, {
                    type: "name",
                    title: "고급",
                    content: "고급 설정을 표시하려면 클릭하십시오."
                }, {
                    type: "name",
                    title: "보안",
                    content: "다음 보안 옵션 중 하나를 선택하십시오",
                    children: [
                        {
                            type: "name",
                            title: "보안 없음",
                            content: "무선 보안을 사용하지 않으려면이 옵션을 선택하십시오. 무단 액세스로부터 무선 네트워크를 보호하기 위해 무선 보안을 활성화하는 것이 <b> 강력하게 권장 </b>됩니다."
                        }, {
                            type: "name",
                            title: "WPA/WPA2-개인",
                            content: "PSK (Pre-shared Key)를 기반으로 표준 인증 방법을 사용하려면이 옵션을 선택합니다. 이 옵션을 사용하는 것이 좋습니다. 선택하는 경우 다음을 구성하십시오.",
                            children: [
                                {
                                    type: "name",
                                    title: "버전",
                                    content: "무선 네트워크에 대한 보안 버전을 선택하십시오.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "자동",
                                            content: "이 옵션은 WPA 및 WPA2와 같은 WPA (Wi-Fi Protected Access) 표준의 다중 구현을 지원합니다."
                                        }, {
                                            type: "name",
                                            title: "WPA-PSK",
                                            content: "이 옵션은 TKIP 및 AES 암호화를 지원합니다."
                                        }, {
                                            type: "name",
                                            title: "WPA2-PSK",
                                            content: "이 옵션은 WPA-PSK보다 향상된 보안 수준을 제공하는 AES 암호화를 지원하며 권장됩니다."
                                        }
                                    ]
                                }, {
                                    type: "name",
                                    title: "암호화",
                                    content: "보안 암호화 유형을 <b> TKIP </b> (임시 키 무결성 프로토콜), <b> AES </b> (고급 암호화 표준) 또는 <b> 자동 </b> (TKIP 및 AES ). TKIP가 802.11n 사양에서 지원되지 않기 때문에 powerline 익스텐더가 802.11n 모드에서 작동하는 경우 TKIP 암호화를 사용하는 것이 <b> NOT </b>됩니다."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "WEP",
                            content: "클라이언트 장치 중 하나가 WEP (Wired Equivalent Privacy)를 사용하여 무선에만 액세스 할 수있는 경우 기본 인증 방법을 사용하려면이 옵션을 선택합니다.",
                            children: [
                                {
                                    type: "name",
                                    title: "타입",
                                    content: "무선 네트워크에 대한 인증 유형을 선택하십시오. 기본값은 무선 클라이언트의 기능 및 액세스 요청에 따라 <b> 시스템 열기 </b> 또는 <b> 공유 키 </b>를 자동으로 선택하는 <b> 자동 </b>입니다."
                                }, {
                                    type: "name",
                                    title: "선택한 키",
                                    content: "네 개의 키 중 하나를 선택하십시오."
                                }, {
                                    type: "name",
                                    title: "WEP 키 형식",
                                    content: "<b> ASCII </b> 또는 <b> 16 진수 </b> 형식을 사용하십시오. ASCII 형식은 영문자와 숫자의 조합입니다. 16 진수 형식은 숫자 (0-9)와 문자 (A-F, a-f)의 조합입니다."
                                }, {
                                    type: "name",
                                    title: "키 타입",
                                    content: "WEP 키 길이를 선택하십시오.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "64-bit",
                                            content: "암호 필드에 10 개의 16 진수 (0-9, A-F, a-f) 또는 5 개의 ASCII 문자를 입력 할 수 있습니다."
                                        }, {
                                            type: "name",
                                            title: "128-bit",
                                            content: "암호 필드에 26 개의 16 진수 (0-9, A-F, a-f) 또는 13 ASCII 문자를 입력 할 수 있습니다."
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "모드",
                    content: "전송 혼합 모드를 선택하십시오."
                }, {
                    type: "name",
                    title: "대역 폭",
                    content: "5GHz 무선 네트워크의 대역폭을 선택하십시오."
                }, {
                    type: "name",
                    title: "대역",
                    content: "5GHz 무선 네트워크의 작동 채널을 선택하십시오. 간헐적 인 무선 연결 문제가없는 경우 채널을 자동으로 설정하는 것이 좋습니다."
                }, {
                    type: "name",
                    title: "송신 전력",
                    content: "High, Middle 또는 Low 중 하나를 선택하여 데이터 전송 전원을 지정하십시오. 기본 및 권장 설정은 높음입니다."
                }, {
                    type: "paragraph",
                    content: "저장을 클릭하여 모든 설정을 저장하십시오."
                }
            ]
        },
        WIFI_TIME_CONTROL: {
            TITLE: "Wi-Fi 스케줄",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Wi-Fi 일정을 사용하면 특정 시간을 설정하여 Wi-Fi를 끌 수 있습니다."
                }, {
                    type: "name",
                    title: "Wi-Fi 스케줄러",
                    content: "Wi-Fi 일정 기능을 사용하려면 <b> on </b>을 선택하십시오. 무선 장치가 여전히 무선 네트워크에 연결되어있는 동안 Wi-Fi를 켜 놓으려면 확인란을 선택하십시오."
                }
            ]
        },
        WIFI_CLONE: {
            TITLE: "Wi-Fi 클론",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Wi-Fi 클론은 기본 무선 라우터에서 Extender로 무선 설정 (SSID 및 무선 암호 포함)을 복사하는 데 사용됩니다."
                }, {
                    type: "name",
                    title: "Wi-Fi 대역 선택",
                    content: "복제 할 대상을 <span class=\"anti_5g\"> 또는 둘 다 </span> 선택하십시오.<span class=\"anti_5g\"> 주 라우터가 한 번에 한 밴드의 복제 만 지원하는 경우 2.4GHz & 5GHz를 사용하여 복제 된 대역이 라우터에서 허용하는 대역과 일치하는지 확인하십시오. </span>"
                }
            ]
        },
        WIFI_TIME_GRID: {
            TITLE: "Wi-Fi 끄기 스케줄",
            CONTENT: [
                {
                    type: "name",
                    title: "에서",
                    content: "Wi-Fi가 꺼져있는 시간을 표시합니다."
                }, {
                    type: "name",
                    title: "에",
                    content: "Wi-Fi가 다시 켜지는 시간을 표시합니다."
                }, {
                    type: "name",
                    title: "일",
                    content: "일정의 유효일을 표시합니다."
                }, {
                    type: "name",
                    title: "상태",
                    content: "일정 사용 여부를 나타냅니다. 전구 아이콘을 클릭하여 스케줄을 활성화 (또는 비활성화)하십시오."
                }, {
                    type: "name",
                    title: "수정",
                    content: "해당 항목을 <b> 수정 </b> 또는 <b> 삭제 </b> 할 수있는 옵션을 표시합니다."
                }, {
                    type: "step",
                    title: "새 일정을 만듭니다",
                    content: ["1. <b> 추가 </b>를 클릭하십시오.", "2. Wi-Fi가 꺼지는 시간 범위를 지정하십시오.", "3. 요일을 선택하십시오.", "4. <b>이 항목 사용 </b>을 선택하십시오.", "5. <b> 확인 </b>을 클릭하여이 항목을 저장하십시오."]
                }, {
                    type: "paragraph",
                    content: "Wi-Fi 항목을 수정하거나 삭제하려면 <b> 수정 </b> 아이콘을 클릭하여 정보를 수정하거나 <b> 휴지통 </b> 아이콘을 클릭하여 해당 항목을 제거하십시오."
                }, {
                    type: "paragraph",
                    content: "여러 개의 스케줄을 삭제하려면 모든 스케줄을 선택하며 표 위에 있는 <b> 삭제 </b>를 클릭하십시오."
                }
            ]
        },
        WPS: {
            TITLE: "공유기의 PIN",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "다른 장치는 공유기의 PIN을 사용하여 WPS에서이 라우터에 연결할 수 있습니다."
                }, {
                    type: "name",
                    title: "공유기의 PIN 사용",
                    content: "공유기의 PIN (개인 식별 번호)을 사용하여 무선 장치를 공유기에 연결할 수 있도록하려면 이 기능을 선택합니다."
                }, {
                    type: "name",
                    title: "공유기의 PIN",
                    content: "공유기의 PIN을 표시합니다. 기본 PIN은 공유기의 라벨이나 사용 설명서에서 찾을 수 있습니다. 생성을 클릭하여 임의로 새 PIN을 생성하거나 기본값을 클릭하여 현재 PIN을 기본 PIN으로 복원합니다."
                }
            ]
        },
        WPS_WIZARD: {
            TITLE: "WPS 마법사",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "설정 방법 선택"
                }, {
                    type: "name",
                    title: "푸시 버튼 (권장)",
                    content: "이 설정 방법을 선택하면 WPS 기능을 사용하여 WPS 단추를 사용하거나 가상으로 연결 단추를 사용하여 WPS 기능 장치를 무선 네트워크에 쉽게 연결할 수 있습니다."
                }, {
                    type: "name",
                    title: "PIN",
                    content: "필드에 무선 장치의 WPS PIN을 입력하고 수동으로 장치를 추가하려면이 설정 방법을 선택하고 연결을 클릭하십시오."
                }
            ]
        },
        WIRELESS_STATISTICS: {
            TITLE: "온라인 무선 클라이언트",
            CONTENT: [
                {
                    type: "name",
                    title: "총 클라이언트",
                    content: "파워라인 네트워크에 연결된 총 무선 클라이언트 수를 표시합니다."
                }, {
                    type: "name",
                    title: "디바이스 이름",
                    content: "무선 클라이언트의 이름을 표시합니다."
                }, {
                    type: "name",
                    title: "IP 주소",
                    content: "무선 클라이언트가 사용중인 IP 주소를 표시합니다."
                }, {
                    type: "name",
                    title: "MAC 주소",
                    content: "무선 클라이언트의 MAC 주소를 표시합니다."
                }, {
                    type: "name",
                    title: "무선 밴드",
                    content: "무선 클라이언트가 연결된 무선 네트워크의 주파수 대역 <span class=\"anti_5g\"> (2.4GHz 또는 5GHz) </span>을 표시합니다."
                }, {
                    type: "name",
                    title: "보안",
                    content: "무선 클라이언트의 보안 유형을 표시합니다."
                }, {
                    type: "paragraph",
                    content: "이 페이지의 정보를 업데이트하려면 <b> 새로 고침 </b>을 클릭하십시오."
                }
            ]
        },
        GUEST_NETWORK_BASIC: {
            TITLE: "게스트 네트워크",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "<b> 게스트 네트워크 </b>를 사용하면 게스트가 인터넷에 액세스 할 때 사용할 수있는 별도의 무선 네트워크 이름 (SSID)과 암호를 사용할 수 있습니다."
                }
            ]
        },
        GUEST_NETWORK_SETTINGS: {
            TITLE: "게스트 네트워크",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "<b> 게스트 네트워크 </b>를 사용하면 게스트가 인터넷에 액세스 할 때 사용할 수있는 별도의 무선 네트워크 이름 (SSID)과 암호를 사용할 수 있습니다."
                }, {
                    type: "name",
                    title: "손님들이 서로를 보도록 허용하십시오",
                    content: "게스트 네트워크의 무선 장치가 서로 통신 할 수있게하려면이 확인란을 선택합니다."
                }, {
                    type: "name",
                    title: "손님이 내 네트워크를 관리하는 것을 허용하지 마십시오.",
                    content: "게스트가 웹 관리 인터페이스에 로그인하지 못하도록하려면이 옵션을 선택합니다."
                }, {
                    type: "name",
                    title: "자동 사용 중지 후",
                    content: "특정 시간을 기준으로 게스트 네트워크를 자동으로 끄려면이 옵션을 선택합니다."
                }, {
                    type: "paragraph",
                    content: "<b> 저장 </b>을 클릭하여 모든 설정을 저장하십시오."
                }
            ]
        },
        GUEST_NETWORK_WIRELESS: {
            TITLE: "게스트 네트워크 설정",
            CONTENT: [
                {
                    type: "name",
                    title: "2.4GHz | 5GHz",
                    content: "설정을 표시하려면 2.4GHz와 5GHz 사이를 전환하십시오."
                }, {
                    type: "name",
                    title: "게스트 네트워크 사용",
                    content: "게스트 네트워크를 활성화하려면 이 확인란을 선택합니다."
                }, {
                    type: "name",
                    title: "네트워크 이름 (SSID)",
                    content: "기본 게스트 SSID를 사용하거나 새 이름을 만듭니다 (최대 32 자)."
                }, {
                    type: "name",
                    title: "보안",
                    content: "다음 보안 옵션 중 하나를 선택하십시오.",
                    children: [
                        {
                            type: "name",
                            title: "보안 없음",
                            content: "무선 보안을 사용하지 않으려면이 옵션을 선택하십시오. 무단 액세스로부터 게스트 네트워크를 보호하기 위해 무선 보안을 활성화하는 것이 <u> <b> 권장 </b> </u>됩니다."
                        }, {
                            type: "name",
                            title: "WPA/WPA2 - 개인",
                            content: "PSK (Pre-shared Key)를 기반으로 표준 인증 방법을 사용하려면이 옵션을 선택합니다. 선택하는 경우 다음을 구성하십시오."
                        }
                    ]
                }, {
                    type: "name",
                    title: "암호",
                    content: "기본 암호를 사용하거나 8 ~ 63 자의 ASCII 문자 또는 8 ~ 64 자의 16 진수 (0-9, a-f, A-F) 사이의 암호를 만드십시오."
                }, {
                    type: "paragraph",
                    content: "<b> 저장 </b>을 클릭하여 게스트 네트워크 무선 설정을 저장하십시오."
                }
            ]
        },
        GUEST_NETWORK_WIRELESS_2G: {
            TITLE: "무선 설정",
            CONTENT: [
                {
                    type: "name",
                    title: "게스트 네트워크 사용",
                    content: "게스트 네트워크를 활성화하려면 이 확인란을 선택합니다."
                }, {
                    type: "name",
                    title: "네트워크 이름 (SSID)",
                    content: "기본 게스트 SSID를 사용하거나 새 이름을 만듭니다 (최대 32 자)."
                }, {
                    type: "name",
                    title: "보안",
                    content: "다음 보안 옵션 중 하나를 선택하십시오.",
                    children: [
                        {
                            type: "name",
                            title: "보안 없음",
                            content: "무선 보안을 사용하지 않으려면이 옵션을 선택하십시오. 무단 액세스로부터 게스트 네트워크를 보호하기 위해 무선 보안을 활성화하는 것이 <u> <b> 권장 </b> </u>됩니다."
                        }, {
                            type: "name",
                            title: "WPA/WPA2 - 개인",
                            content: "PSK (Pre-shared Key)를 기반으로 표준 인증 방법을 사용하려면이 옵션을 선택합니다. 선택하는 경우 다음을 구성하십시오."
                        }
                    ]
                }, {
                    type: "name",
                    title: "암호",
                    content: "기본 암호를 사용하거나 8 ~ 63 자의 ASCII 문자 또는 8 ~ 64 자의 16 진수 (0-9, a-f, A-F) 사이의 암호를 만드십시오."
                }, {
                    type: "paragraph",
                    content: "<b> 저장 </b>을 클릭하여 게스트 네트워크 무선 설정을 저장하십시오."
                }
            ]
        },
        NAT: {
            TITLE: "ALG (응용 프로그램 층 게이트웨이)",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "ALG를 사용하면 특정 응용 프로그램 계층 \"제어 / 데이터\"프로토콜 (FTP, TFTP, H323 등)에 대한 주소 및 포트 변환을 지원하기 위해 사용자 지정 NAT (Network Address Translation) 탐색 필터를 게이트웨이에 연결할 수 있습니다. ALG를 활성화하는 것이 좋습니다."
                }, {
                    type: "name",
                    title: "FTP ALG 사용",
                    content: "이 옵션을 선택하면 FTP (File Transfer Protocol) 클라이언트와 서버가 NAT를 통해 데이터를 전송할 수 있습니다."
                }, {
                    type: "name",
                    title: "TFTP ALG 사용",
                    content: "이 옵션을 선택하면 TFTP (Trivial File Transfer Protocol) 클라이언트와 서버가 NAT를 통해 데이터를 전송할 수 있습니다."
                }, {
                    type: "name",
                    title: "H323 ALG 사용",
                    content: "이 옵션을 선택하면 Microsoft NetMeeting 클라이언트가 NAT를 통해 통신 할 수 있습니다."
                }, {
                    type: "name",
                    title: "RTSP ALG 사용",
                    content: "이 옵션을 선택하면 미디어 플레이어 클라이언트가 NAT를 통해 스트리밍 미디어 서버와 통신 할 수 있습니다."
                }, {
                    type: "name",
                    title: "PPTP Passthrough 사용",
                    content: "이 옵션을 선택하면 지점 간 세션을 IP 네트워크를 통해 터널링하고 라우터를 통과 할 수 있습니다."
                }, {
                    type: "name",
                    title: "L2TP Passthrough 사용",
                    content: "이 옵션을 선택하면 Layer 2 Point-to-Point 세션을 IP 네트워크를 통해 터널링하고 라우터를 통과 할 수 있습니다."
                }, {
                    type: "name",
                    title: "IPSec Passthrough 사용",
                    content: "이 옵션을 선택하면 인터넷 프로토콜 보안 (IPSec)을 IP 네트워크를 통해 터널링하고 라우터를 통과 할 수 있습니다. IPSec은 암호화 된 보안 서비스를 사용하여 IP 네트워크에서 개인 및 보안 통신을 보장합니다."
                }, {
                    type: "paragraph",
                    content: "저장을 클릭하여 모든 설정을 저장하십시오."
                }
            ]
        },
        VIRTUAL_SERVERS: {
            TITLE: "가상 서버",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "가상 서버는 로컬 네트워크에서 공용 서비스를 설정하는 데 사용됩니다. 가상 서버는 외부 포트로 정의되며 인터넷에서이 외부 포트로의 모든 요청은 지정된 컴퓨터로 리디렉션됩니다.이 컴퓨터는 정적 또는 예약 된 IP 주소로 구성되어야합니다."
                }, {
                    type: "name",
                    title: "서비스 유형",
                    content: "가상 서버의 이름을 표시합니다."
                }, {
                    type: "name",
                    title: "외부 포트",
                    content: "가상 서버에서 사용하는 포트 번호 또는 포트 범위를 표시합니다."
                }, {
                    type: "name",
                    title: "내부 IP",
                    content: "서비스 응용 프로그램을 실행하는 컴퓨터의 IP 주소를 표시합니다."
                }, {
                    type: "name",
                    title: "내부 포트",
                    content: "서비스 응용 프로그램을 실행중인 컴퓨터의 포트 번호를 표시합니다."
                }, {
                    type: "name",
                    title: "프로토콜",
                    content: "서비스 응용 프로그램에 사용되는 프로토콜 (TCP, UDP 또는 All (라우터에서 지원하는 모든 프로토콜))을 표시합니다."
                }, {
                    type: "name",
                    title: "상태",
                    content: "특정 필터링 규칙의 현재 상태 (활성화 또는 비활성화)를 표시합니다."
                }, {
                    type: "name",
                    title: "수정",
                    content: "해당 규칙 수정 또는 삭제 옵션을 표시합니다."
                }, {
                    type: "step",
                    title: "가상 서버 규칙을 설정합니다",
                    content: ["1. 추가를 클릭하십시오", "2. 기존 서비스보기를 클릭하여 목록에서 서비스를 선택하여 외부 포트 및 내부 포트 필드에 적절한 포트 번호를 자동으로 채 웁니다. 목록에 서비스가 없으면 외부 포트 번호 (예 : 21) 또는 포트 범위 (예 : 21-25)를 입력하십시오. 내부 포트는 외부 포트와 동일한 경우 비워 두거나 외부 포트가 단일 포트 인 경우 특정 포트 번호 (예 : 21)를 입력하십시오. 점 분리 10 진수 형식의 서비스 응용 프로그램을 실행중인 컴퓨터의 IP 주소를 내부 IP 필드에 입력하십시오.", "3. 프로토콜 드롭 다운 목록에서 서비스 응용 프로그램에 대한 프로토콜 (TCP, UDP 또는 모두)을 선택하십시오. ", "4. 사용을 선택하십시오.", "5. 확인을 클릭하십시오"]
                }, {
                    type: "step",
                    title: "가상 서버 규칙을 수정하거나 삭제합니다",
                    content: "수정 또는 삭제하려는 규칙에 해당하는 수정 아이콘 또는 휴지통 아이콘을 클릭하십시오."
                }, {
                    type: "step",
                    title: "여러 규칙을 삭제합니다",
                    content: "삭제할 항목을 모두 선택하고 표 위의 삭제를 클릭하십시오."
                }, {
                    type: "note",
                    title: "참고",
                    content: "로컬 호스트 장치가 둘 이상의 유형의 사용 가능한 서비스를 호스팅하는 경우 각 서비스에 대한 규칙을 만들어야합니다."
                }
            ]
        },
        PORT_TRIGGERING: {
            TITLE: "포트 트리거링",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "포트 트리거링은 특정 포트의 트래픽을 네트워크의 특정 서버로 전달하는 데 사용됩니다."
                }, {
                    type: "name",
                    title: "어플리케이션",
                    content: "응용 프로그램의 이름을 표시합니다."
                }, {
                    type: "name",
                    title: "트리거 포트",
                    content: "나가는 연결의 필터링 규칙을 트리거하는 데 사용되는 나가는 트래픽 포트를 표시합니다."
                }, {
                    type: "name",
                    title: "트리거 프로토콜",
                    content: "트리거 포트에 사용 된 프로토콜을 표시합니다. TCP, UDP 또는 All (라우터가 지원하는 모든 프로토콜)."
                }, {
                    type: "name",
                    title: "외부 포트",
                    content: "원격 시스템에서 사용하는 포트 또는 포트 범위를 표시합니다. 이 포트 중 하나를 사용하는 응답은이 규칙을 트리거하는 PC로 전달됩니다. 최대 5 개의 포트 그룹 (또는 포트 섹션)을 입력 할 수 있습니다. 모든 포트 그룹은 \",\"(쉼표)로 구분해야합니다 (예 : 2000-2038, 2046, 2050-2051, 2085, 3010-3030)."
                }, {
                    type: "name",
                    title: "외부 프로토콜",
                    content: "수신 포트에 사용되는 프로토콜 (TCP, UDP 또는 ALL (라우터에서 지원하는 모든 프로토콜))을 표시합니다."
                }, {
                    type: "name",
                    title: "상태",
                    content: "특정 필터링 규칙의 현재 상태 (활성화 또는 비활성화)를 표시합니다."
                }, {
                    type: "name",
                    title: "수정",
                    content: "수정 또는 삭제 및 해당 규칙에 대한 옵션을 표시합니다."
                }, {
                    type: "step",
                    title: "포트 트리거링 규칙을 설정합니다",
                    content: [
                        {
                            type: "note",
                            title: "참고",
                            content: "각 규칙은 한 번에 한 호스트에서만 사용할 수 있습니다."
                        },
                        "1. 추가를 클릭하십시오.", {
                            content: "2. 기존 응용 프로그램보기를 클릭하여 목록에서 응용 프로그램을 선택하여 기본값을 해당 필드에 자동으로 채 웁니다. 목록에없는 응용 프로그램을 추가하려면 응용 프로그램, 트리거 포트, 트리거 프로토콜, 외부 포트 및 외부 프로토콜을 수동으로 입력하십시오.",
                            children: [
                                {
                                    type: "note",
                                    title: "참고",
                                    content: "규칙은 서로 겹치는 포트 범위를 가질 수 없습니다 (예 : 규칙 1의 포트 범위는 4200-4205이며 규칙 2는 4203-4206의 포트 범위를 가질 수 없음을 나타냄)."
                                }
                            ]
                        },
                        "3. 사용을 선택하십시오.",
                        "4. 확인을 클릭하십시오."
                    ]
                }, {
                    type: "step",
                    title: "포트 트리거링 규칙을 수정하거나 삭제합니다",
                    content: "표에서 수정 또는 삭제할 규칙에 해당하는 수정 아이콘 또는 휴지통 아이콘을 클릭하십시오."
                }, {
                    type: "step",
                    title: "여러 포트 트리거링 규칙을 삭제합니다",
                    content: "표에서 삭제할 규칙을 모두 선택하고 표 위에있는 삭제를 클릭하십시오."
                }
            ]
        },
        DMZ: {
            TITLE: "DMZ",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "DMZ (비무장 지대) 호스트 기능을 사용하면 로컬 호스트가 인터넷 게임이나 화상 회의와 같은 특수 용도의 서비스를 위해 인터넷에 노출 될 수 있습니다. 기본적으로 DMZ를 사용하면 LAN상의 단일 컴퓨터에서 모든 포트를 열 수 있습니다. 이 컴퓨터는 고정 IP 주소로 구성되어야하며 DHCP 클라이언트 기능이 비활성화되어 있어야합니다."
                }, {
                    type: "step",
                    title: "컴퓨터 또는 서버를 DMZ 서버로 지정하려면",
                    content: ["1. DMZ 사용을 클릭하십시오.", "2. DMZ 호스트 IP 주소 필드에 DMZ 호스트로 설정할 로컬 컴퓨터의 IP 주소를 입력하십시오.", "3. 저장을 클릭하십시오."]
                }
            ]
        },
        UPNP: {
            TITLE: "UPnP",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "기본적으로 UPnP (Universal Plug-and-Play) 기능을 사용하면 컴퓨터 및 인터넷 어플라이언스와 같은 장치가 로컬 네트워크에서 서로를 자동으로 검색하고 통신 할 수 있습니다."
                }, {
                    type: "paragraph",
                    content: "UPnP 서비스리스트는 UPnP 장치 정보를 표시합니다."
                }, {
                    type: "name",
                    title: "서비스 설명",
                    content: "UPnP 요청을 시작하는 로컬 호스트에 대한 간략한 설명을 표시합니다."
                }, {
                    type: "name",
                    title: "외부 포트",
                    content: "로컬 호스트가 연 외부 포트를 표시합니다."
                }, {
                    type: "name",
                    title: "프로토콜",
                    content: "로컬 호스트에서 사용되는 네트워크 프로토콜 유형을 표시합니다."
                }, {
                    type: "name",
                    title: "내부 IP 주소",
                    content: "로컬 호스트의 IP 주소를 표시합니다."
                }, {
                    type: "name",
                    title: "내부 포트",
                    content: "로컬 호스트에서 열린  내부 포트를 표시합니다."
                }, {
                    type: "paragraph",
                    content: "새로 고침을 클릭하여 UPnP 서버 목록을 업데이트하십시오."
                }
            ]
        },
        DISK_SETTING: {
            TITLE: "디바이스 설정",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "장치 설정 페이지에는 USB 포트를 통해 연결된 USB 저장 장치의 관련 정보가 표시됩니다."
                }, {
                    type: "name",
                    title: "스캔",
                    content: "일반적으로 공유기는 새로 연결된 장치를 자동으로 감지합니다. 그렇지 않은 경우이 단추를 클릭하여 연결된 새 장치를 검색하고 업데이트 된 정보로 페이지를 새로 고칩니다."
                }, {
                    type: "name",
                    title: "볼륨",
                    content: "USB 볼륨의 이름을 표시합니다."
                }, {
                    type: "name",
                    title: "용량",
                    content: "USB의 총 저장 용량을 표시합니다."
                }, {
                    type: "name",
                    title: "사용 가능 공간",
                    content: "사용 가능한 현재 사용 가능한 저장 공간을 표시합니다."
                }, {
                    type: "name",
                    title: "안전 제거",
                    content: "USB 저장 장치를 실제로 연결 해제하기 전에 USB 저장 장치를 안전하게 분리하려면이 단추를 클릭하십시오."
                }, {
                    type: "paragraph",
                    content: "안전하게 제거 버튼은 라우터에 연결된 USB 저장 장치가있는 경우에만 나타나며 현재 볼륨이 사용중인 동안에는 USB 장치를 마운트 해제 할 수 없습니다."
                }, {
                    type: "name",
                    title: "유효",
                    content: "이 체크 박스는 공유기에 연결된 USB 저장 장치가있는 경우에만 나타납니다. USB 장치의 파일 공유를 활성화하려면 선택합니다."
                }, {
                    type: "step",
                    title: "파일 서버를 설정합니다",
                    content: ["1. USB 저장 장치를 USB 케이블을 사용하여 공유기의 USB 포트에 연결하십시오.", "2. 새로 연결된 USB 장치가 라우터에서 자동으로 감지되고 장치 설정 섹션에 정보가 표시되어야합니다. 그렇지 않은 경우 스캔을 클릭하십시오.", "3. 파일 공유를 사용하려면 활성을 선택하십시오."]
                }
            ]
        },
        FOLDER_SHARE_ACCOUNT: {
            TITLE: "계정 공유",
            CONTENT: [
                {
                    type: "name",
                    title: "계정",
                    content: "기본 계정을 사용하여 공유 파일 및 폴더에 로그인하거나 새 계정 사용을 선택하고 다음을 입력하여 새 사용자 계정을 만들 수 있습니다."
                }, {
                    type: "name",
                    title: "사용자 이름 / 암호",
                    content: "최대 15 자 길이의 영숫자 또는 밑줄 문자열을 입력하십시오. 사용자 이름은 알파벳 문자로 시작해야합니다. 이 필드는 대소 문자를 구분합니다."
                }, {
                    type: "name",
                    title: "암호 확인",
                    content: "오타가 없는지 확인하기 위해 암호를 다시 입력하십시오. 이 필드는 대소 문자를 구분합니다."
                }, {
                    type: "paragraph",
                    content: "저장을 클릭하여 새 사용자 계정을 저장합니다."
                }
            ]
        },
        FOLDER_SHARE_SETTINGS: {
            TITLE: "공유 설정",
            CONTENT: [
                {
                    type: "name",
                    title: "네트워크 / 미디어 서버 이름",
                    content: "연결된 USB 저장 장치에 액세스하는 데 사용 된 이름을 표시합니다."
                }, {
                    type: "name",
                    title: "사용",
                    content: "액세스 방법을 사용하려면 선택하십시오."
                }, {
                    type: "name",
                    title: "액세스 방법",
                    content: "연결된 USB 저장 장치에 대한 액세스를 허용하는 세 가지 액세스 방법이 있습니다. 해당 확인란을 선택하여 하나 이상의 액세스 방법을 선택할 수 있습니다.",
                    children: [
                        {
                            type: "name",
                            title: "네트워크 환경",
                            content: "사용하도록 설정된 경우 네트워크의 사용자는 지정된 IP 주소 (예 : \\\\ 192.168.0.1)를 사용하여 USB 저장 장치에 액세스 할 수 있습니다. 이 방법은 기본적으로 사용 가능합니다."
                        }, {
                            type: "name",
                            title: "FTP",
                            content: "사용 설정되면 로컬 네트워크의 FTP 클라이언트는 할당 된 IP 주소와 FTP 서버의 포트 번호 (예 : ftp://192.168.0.1:21)를 사용하여 USB 저장 장치에 액세스 할 수 있습니다."
                        }, {
                            type: "name",
                            title: "FTP (인터넷을 통한)",
                            content: "활성화 된 경우 사용자는 인터넷을 통해 FTP를 통해 USB 저장 장치 드라이브에 원격으로 액세스 할 수 있습니다. 이 기능은 파일 다운로드 및 업로드를 모두 지원합니다. FTP 서버의 포트 번호를 변경하려면 포트 번호를 입력하고 저장을 클릭하여 변경 사항을 적용하십시오."
                        }
                    ]
                }, {
                    type: "name",
                    title: "링크",
                    content: "공유 USB 저장 장치에 액세스하는 데 사용되는 주소를 표시합니다."
                }, {
                    type: "name",
                    title: "포트",
                    content: "FTP 서버의 포트 번호를 표시합니다."
                }
            ]
        },
        FOLDER_SHARE_FOLDERS: {
            TITLE: "폴더 공유",
            CONTENT: [
                {
                    type: "name",
                    title: "모두 공유",
                    content: "모든 파일 및 폴더를 공유하려면 켜짐으로 전환하고, 선택한 폴더 만 공유하려면 끄기로 전환하십시오."
                }, {
                    type: "name",
                    title: "인증 사용",
                    content: "사용자가 공유 폴더에 액세스하려면 유효한 사용자 이름과 암호를 입력하도록 인증을 사용하도록 설정하는 것이 좋습니다."
                }, {
                    type: "name",
                    title: "폴더 이름",
                    content: "공유 폴더의 이름을 표시합니다."
                }, {
                    type: "name",
                    title: "폴더 경로",
                    content: "공유 폴더의 경로를 표시합니다."
                }, {
                    type: "name",
                    title: "미디어 공유",
                    content: "공유 폴더에서 미디어 공유가 허용되는지 여부를 나타냅니다."
                }, {
                    type: "name",
                    title: "볼륨 이름",
                    content: "공유 볼륨의 이름을 표시합니다."
                }, {
                    type: "name",
                    title: "상태",
                    content: "전구 표시기로 공유 폴더의 상태를 표시합니다. 녹색 (ON)이 활성화되고 회색 (OFF)이 비활성화됩니다. 전구를 클릭하여 공유를 활성화 또는 비활성화 할 수 있습니다."
                }, {
                    type: "name",
                    title: "수정",
                    content: "해당 공유 폴더 수정 또는 삭제 옵션을 표시합니다."
                }, {
                    type: "name",
                    title: "검색",
                    content: "공유 폴더를 검색하려면 클릭하십시오."
                }, {
                    type: "name",
                    title: "게스트 네트워크 액세스 허용",
                    content: "게스트 네트워크의 클라이언트가 공유 폴더에 액세스 할 수있게 하려면 선택하십시오."
                }, {
                    type: "name",
                    title: "인증 사용",
                    content: "사용자가 유효한 사용자 이름과 암호로 공유 폴더에 액세스하도록 요구할 때 선택하십시오."
                }, {
                    type: "name",
                    title: "쓰기 액세스 사용",
                    content: "사용자가 폴더 내용을 변경할 수있게 하려면 선택하십시오."
                }, {
                    type: "name",
                    title: "미디어 공유 사용",
                    content: "미디어 공유를 활성화하려면 선택하십시오."
                }
            ]
        },
        PRINT_SERVER: {
            TITLE: "프린터 서버",
            CONTENT: [
                {
                    type: "step",
                    title: "네트워크에서 사용할 수있는 인쇄 서버를 설정합니다",
                    content: ["1. USB 프린터를 USB 케이블을 통해 라우터의 USB 포트에 연결하십시오.", "2. 컴퓨터에 프린터 드라이버를 설치하십시오. 지시 사항은 컴퓨터 제조업체의 설명서를 참조하십시오.", "3. TP-LINK 공식 웹 사이트에서 리소스 CD (Windows 전용) 또는 TP-LINK (Windows 및 Mac OS X 용)에서 TP-LINK USB 프린터 컨트롤러 유틸리티를 다운로드하십시오."]
                }
            ]
        },
        PARENTAL_CONTROL: {
            TITLE: "자녀 보호",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "자녀 보호 기능을 사용하면 무선 장치에 대한 시간 제한을 설정하고 이러한 장치가 인터넷에 액세스 할 수있는시기를 제어 할 수 있습니다."
                }, {
                    type: "name",
                    title: "자녀 보호",
                    content: "자녀 보호 기능을 사용하려면 <b> 사용 </b>으로 전환하십시오."
                }
            ]
        },
        PARENTAL_CONTROL_DEVICES: {
            TITLE: "유해 컨텐츠 차단 장치",
            CONTENT: [
                {
                    type: "name",
                    title: "ID",
                    content: "클라이언트 장치의 ID를 표시합니다."
                }, {
                    type: "name",
                    title: "MAC 주소",
                    content: "클라이언트 장치의 MAC 주소를 표시합니다."
                }, {
                    type: "name",
                    title: "인터넷 접속 시간",
                    content: "허용 된 액세스 시간을 표시합니다."
                }, {
                    type: "name",
                    title: "설명",
                    content: "연결된 장치에 대한 간략한 설명을 표시합니다."
                }, {
                    type: "name",
                    title: "상태",
                    content: "해당 장치에 대해 자녀 보호 기능이 켜져 있는지 여부를 나타냅니다."
                }, {
                    type: "name",
                    title: "수정",
                    content: "기기를 <b> 수정 </b>하거나 <b> 삭제 </b> 할 수있는 옵션을 표시합니다."
                }, {
                    type: "step",
                    title: "새 클라이언트 장치에 시간 제한을 설정합니다",
                    content: [
                        "1. <b> 추가 </b>를 클릭하십시오.",
                        "2. <b> 기존 장치보기 </b>를 클릭하고 <b> 무선 액세스 장치 </b> 목록에서 현재 연결된 장치를 선택하십시오. 또는 <b> MAC 주소 </b>를 직접 입력하여 연결되지 않은 장치를 추가하십시오.",
                        "3. <b> 인터넷 액세스 시간 </b> 아이콘을 클릭하여 장치가 인터넷에 액세스 할 수있는 시간 범위를 지정하십시오.",
                        "4. <b> 설명 </b> 입력란에 간단한 설명을 입력하십시오. 이 필드는 선택 사항입니다.",
                        "5. <b>이 항목 활성화 </b>를 선택하십시오.",
                        "6. <b> 확인 </b>을 클릭하여이 항목을 저장하십시오."
                    ]
                }, {
                    type: "paragraph",
                    content: "목록에서 기기를 수정하거나 삭제하려면 <b> 수정 </b> 아이콘을 클릭하여 정보를 수정하거나 <b> 휴지통 </b> 아이콘을 클릭하여 해당 항목을 제거하십시오."
                }, {
                    type: "paragraph",
                    content: "목록에서 여러 개의 기기를 삭제하려면 삭제할 기기의 확인란을 선택한 다음 표 위에서 <b> 삭제 </b>를 클릭하십시오."
                }
            ]
        },
        PARENTAL_CONTROL_RESTRICTION: {
            TITLE: "콘텐츠 제한",
            CONTENT: [
                {
                    type: "name",
                    title: "블랙리스트",
                    content: "유해 컨텐츠 차단 목록에 지정된 클라이언트 장치에서 웹 사이트 액세스를 차단하는 데 사용할 키워드가 들어 있습니다.",
                    children: [
                        {
                            type: "paragraph",
                            content: "블랙리스트에 키워드를 추가하려면 새 키워드 추가를 클릭하십시오. 키워드를 삭제하려면 삭제할 키워드의 (-) 아이콘을 클릭하십시오."
                        }
                    ]
                }, {
                    type: "name",
                    title: "화이트리스트",
                    content: "유해 컨텐츠 차단 목록에 지정된 클라이언트 장치가 액세스 할 수있는 웹 사이트 주소를 포함합니다.",
                    children: [
                        {
                            type: "paragraph",
                            content: "화이트리스트에 웹 사이트를 추가하려면 새 도메인 이름 추가를 클릭하십시오. 웹 사이트를 삭제하려면 삭제할 웹 사이트의 (-) 아이콘을 클릭하십시오."
                        }
                    ]
                }, {
                    type: "note",
                    title: "참고",
                    content: "키워드는 도메인 이름 (예 : www.mail.google.com 또는 www.facebook.com) 일 수도 있습니다."
                }, {
                    type: "paragraph",
                    content: "저장을 클릭하여 구성을 저장하십시오."
                }
            ]
        },
        QOS: {
            TITLE: "QoS",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "서비스 품질 (QoS)은 필요에 따라 인터넷 트래픽의 우선 순위를 지정하는 데 도움이됩니다. QoS 규칙 목록에서 장치 또는 응용 프로그램의 우선 순위 수준을 지정할 수 있습니다."
                }, {
                    type: "note",
                    title: "참고",
                    content: "NAT Boost가 활성화되면 QoS를 비활성화해야합니다."
                }, {
                    type: "name",
                    title: "QoS 사용",
                    content: "QoS 기능을 사용하려면이 상자를 누르십시오."
                }, {
                    type: "name",
                    title: "대역폭 업로드",
                    content: "ISP (인터넷 서비스 공급자)가 제공하는 최대 업로드 대역폭을 입력하십시오."
                }, {
                    type: "name",
                    title: "다운로드 대역폭",
                    content: "ISP에서 제공하는 최대 다운로드 대역폭을 입력하십시오."
                }, {
                    type: "name",
                    title: "높은 우선 순위 보장",
                    content: "높은 우선 순위 트래픽에 대한 백분율을 지정하십시오."
                }, {
                    type: "name",
                    title: "중간 우선권 보장",
                    content: "중간 우선 순위 트래픽의 백분율을 지정하십시오."
                }, {
                    type: "name",
                    title: "낮은 우선 순위 보장",
                    content: "낮은 우선 순위 트래픽에 대한 백분율을 지정하십시오."
                }, {
                    type: "note",
                    title: "참고",
                    content: "모든 우선 순위의 양 (백분율)은 1이어야합니다."
                }, {
                    type: "paragraph",
                    content: "저장을 클릭하여 모든 설정을 저장하십시오."
                }
            ]
        },
        QOS_RULE: {
            TITLE: "QoS 규칙 목록",
            CONTENT: [
                {
                    type: "name",
                    title: "타입",
                    content: "QoS 규칙 목록을 추가 할 유형을 선택하십시오."
                }, {
                    type: "step",
                    title: "각 장치 높음 / 중간 / 낮음 우선 순위에 대한 규칙을 설정합니다",
                    content: ["1. 추가를 클릭하십시오.", "2. 장치 별을 선택하십시오.", "3. 기존 장치보기를 클릭하여 액세스 장치 목록에서 원하는 장치를 선택하거나 장치 이름과 MAC 주소를 장치 이름 및 MAC 주소 필드에 수동으로 입력 할 수 있습니다.", "4. 확인을 클릭하십시오."]
                }, {
                    type: "step",
                    title: "각 응용 프로그램 높음 / 중간 / 낮음 우선 순위에 대한 규칙을 설정합니다",
                    content: ["1. 추가를 클릭하십시오.", "2. 각 응용 프로그램을 선택하십시오.", "3. 응용 프로그램 목록에서 원하는 응용 프로그램을 선택하거나 해당 필드에 이름, 프로토콜 및 포트를 구성하여 응용 프로그램을 사용자 정의 할 수 있습니다.", "4. 확인을 클릭하십시오."]
                }, {
                    type: "step",
                    title: "높음 / 중간 / 낮음 우선 순위에 따라 규칙을 설정합니다",
                    content: ["1. 추가를 클릭하십시오.", "2. 실제 각 포트를 선택하십시오.", "3. 원하는 포트를 선택하십시오.", "4. 확인을 클릭하십시오."]
                }
            ]
        },
        QOS_DATABASE: {
            TITLE: "데이터베이스 업그레이드",
            CONTENT: [
                {
                    type: "name",
                    title: "새 데이터베이스 파일",
                    content: "찾아보기를 클릭하여 새 데이터베이스 파일을 찾습니다. 업그레이드를 선택하고 클릭하여 데이터베이스를 최신 버전으로 업그레이드하십시오."
                }, {
                    type: "name",
                    title: "데이터베이스 버전",
                    content: "현재 데이터베이스 버전을 표시합니다."
                }
            ]
        },
        SECURITY_FIREWALL: {
            TITLE: "방화벽",
            CONTENT: [
                {
                    type: "name",
                    title: "SPI 방화벽",
                    content: "SPI (Stateful Packet Inspection) 방화벽은 사이버 공격을 방지하고 프로토콜을 기반으로 라우터를 통과하는 트래픽의 유효성을 검사합니다. SPI 방화벽은 기본적으로 활성화되어 있습니다."
                }
            ]
        },
        SECURITY_DOS: {
            TITLE: "DoS 보호",
            CONTENT: [
                {
                    type: "name",
                    title: "DoS 보호",
                    content: "DoS (Denial of Service) 보호는 서버 요청으로 네트워크를 범람하여 DoS 공격으로부터 LAN을 보호합니다. 기본적으로 DoS 보호는 비활성화 (해제)되어 있습니다."
                }, {
                    type: "name",
                    title: "ICMP-FLOOD 공격 필터링",
                    content: "인터넷 제어 메시지 프로토콜 (ICMP) 홍수 공격을 방지 할 수 있습니다."
                }, {
                    type: "name",
                    title: "UDP-FLOOD 공격 필터링",
                    content: "UDP (User Datagram Protocol) 플러드 공격을 방지 할 수 있습니다."
                }, {
                    type: "name",
                    title: "TCP-SYN-FLOOD 공격 필터링",
                    content: "TCP-SYN (Transmission Control Protocol-Synchronization) 공격을 방지합니다.",
                    children: [
                        {
                            type: "name",
                            title: "끄기",
                            content: "보호가 없습니다."
                        }, {
                            type: "name",
                            title: "낮음",
                            content: "낮은 수준의 보호 및 공유기 성능에 미치는 영향 낮습니다."
                        }, {
                            type: "name",
                            title: "중간",
                            content: "보통 수준의 보호 및 공유기 성능에 대한 영향이 있습니다."
                        }, {
                            type: "name",
                            title: "높음",
                            content: "높은 수준의 보호 기능이지만 라우터 성능에 큰 영향을 미칩니다."
                        }
                    ]
                }, {
                    type: "name",
                    title: "WAN 포트에서 Ping 패킷 무시",
                    content: "WAN 포트에서 ping 패킷을 무시하도록 설정합니다."
                }, {
                    type: "name",
                    title: "LAN 포트에서 Ping 패킷 금지",
                    content: "LAN 포트에서 패킷을 ping 할 수 없습니다."
                }
            ]
        },
        MAC_FILTER_ALL: {
            TITLE: "MAC 필터",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "MAC 필터링은 특정 컴퓨터 및 기타 장치가 네트워크에 액세스하는 것을 허용하거나 차단하는 데 사용됩니다. 장치가 차단되면 전력선 장치에 연결할 수 없습니다."
                }, {
                    type: "name",
                    title: "MAC 필터 설정",
                    children: [
                        {
                            type: "name",
                            title: "MAC 필터",
                            content: "이 기능을 사용하려면 <b> 사용 </b>으로 전환하십시오. 기능이 비활성화 (꺼짐)되어 있으면 모든 장치를 연결할 수 있습니다."
                        }
                    ]
                }, {
                    type: "name",
                    title: "필터링 규칙 선택",
                    content: "장치 목록에 나열된 클라이언트 장치가 무선 네트워크에 액세스하는 것을 차단하거나 허용하려면 선택합니다. <b> 저장 </b>을 클릭하여 설정을 저장하십시오."
                }, {
                    type: "name",
                    title: "디바이스 목록",
                    children: [
                        {
                            type: "step",
                            title: "클라이언트 디바이스를 추가합니다"
                        }, {
                            type: "step",
                            title: "클라이언트 디바이스를 수정하거나 삭제합니다",
                            content: "수정 또는 삭제하려는 기기에 해당하는 <b> 수정 </b> 아이콘 또는 <b> 휴지통 </b> 아이콘을 클릭하십시오."
                        }, {
                            type: "step",
                            title: "장치 목록에서 여러 장치를 삭제합니다",
                            content: "삭제할 기기의 해당 확인란을 선택하고 표 위에서 <b> 삭제 </b>를 클릭하십시오."
                        }
                    ]
                }
            ]
        },
        MAC_FILTER: {
            TITLE: "MAC 필터",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "MAC 필터링은 특정 컴퓨터 및 기타 장치가 네트워크에 액세스하는 것을 허용하거나 차단하는 데 사용됩니다. 장치가 차단되면 전력선 장치에 연결할 수 없습니다."
                }, {
                    type: "name",
                    title: "MAC 필터 설정",
                    children: [
                        {
                            type: "name",
                            title: "MAC 필터",
                            content: "이 기능을 사용하려면 <b> 사용 </b>으로 전환하십시오. 기능이 비활성화 (꺼짐)되어 있으면 모든 장치를 연결할 수 있습니다."
                        }
                    ]
                }
            ]
        },
        MAC_FILTER_RULES: {
            TITLE: "필터링 규칙 선택",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "장치 목록에 나열된 클라이언트 장치가 무선 네트워크에 액세스하는 것을 차단하거나 허용하려면 선택합니다."
                }, {
                    type: "paragraph",
                    content: "<b> 저장 </b>을 클릭하여 설정을 저장하십시오."
                }
            ]
        },
        MAC_FILTER_DEVICE_LIST: {
            TITLE: "디바이스 리스트",
            CONTENT: [
                {
                    type: "step",
                    title: "클라이언트 장치를 추가합니다",
                    content: ["1. <b> 추가 </b>를 클릭하십시오.", "2. <b> 장치보기 </b>를 클릭하고 목록에서 장치의 MAC 주소를 선택하거나 수동으로 MAC 주소를 입력하십시오.", "3. 장치에 대한 간단한 설명을 제공하십시오.", "4. <b>이 항목을 활성화하십시오. </b>를 선택하십시오.", "5. <b> 확인 </b>을 클릭하십시오."]
                }, {
                    type: "step",
                    title: "장치 목록에서 장치를 수정하거나 삭제합니다",
                    content: "수정 또는 삭제하려는 기기에 해당하는 <b> 수정 </b> 아이콘 또는 <b> 휴지통 </b> 아이콘을 클릭하십시오."
                }, {
                    type: "step",
                    title: "장치 목록에서 여러 장치를 삭제합니다",
                    content: "삭제할 기기의 해당 확인란을 선택하고 표 위에서 <b> 삭제 </b>를 클릭하십시오."
                }
            ]
        },
        WIFI_MOVE: {
            TITLE: "Wi-Fi 이동",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Wi-Fi 이동 기능을 사용하면 하나의 전력선 익스텐더의 Wi-Fi 설정에 대한 변경 사항이 Wi-Fi 이동 기능이 활성화 된 동일한 전력선 네트워크의 다른 전력선 익스텐더와 자동으로 동기화됩니다. 공장 출고시 HomePlugAV와 같은 기본 이름이 사용 중이면 Wi-Fi 이동 기능이 자동으로 비활성화됩니다."
                }, {
                    type: "name",
                    title: "Wi-Fi 이동",
                    content: "이 기능을 사용하려면 <b> 사용 </b>으로 전환하십시오."
                }
            ]
        },
        SECURITY_LIST: {
            TITLE: "차단 된 DoS 호스트 목록",
            CONTENT: [
                {
                    type: "name",
                    title: "차단 된 DoS 호스트 목록",
                    content: "차단 된 DoS 공격 소스의 IP 주소 및 MAC 주소를 나열합니다."
                }, {
                    type: "step",
                    title: "항목을 삭제합니다",
                    content: "호스트 목록에서 삭제할 항목을 선택하고 표 위에서 삭제를 클릭하십시오."
                }
            ]
        },
        ACCESS_CONTROL: {
            TITLE: "액세스 제어",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "액세스 제어는 특정 컴퓨터 및 기타 장치가 네트워크에 액세스하는 것을 허용하거나 차단하는 데 사용됩니다. 장치가 차단되면 라우터에서 IP 주소를 가져올 수 있지만 다른 장치와 통신 할 수 없거나 인터넷에 연결할 수 없습니다."
                }, {
                    type: "paragraph",
                    content: "액세스 제어를 사용하려면 이 기능을 활성화하고 화이트 블랙 리스트를 지정하십시오. 액세스 제어가 비활성화되어 있으면 (끄기) 블랙리스트에있는 장치를 포함하여 모든 장치를 연결할 수 있습니다."
                }
            ]
        },
        ACCESS_MODE: {
            TITLE: "액세스 모드",
            CONTENT: [
                {
                    type: "name",
                    title: "블랙리스트",
                    content: "블랙리스트에 있는 장치 만 네트워크에 액세스 할 수 없습니다."
                }, {
                    type: "name",
                    title: "화이트리스트",
                    content: "허용 목록에있는 장치 만 네트워크에 액세스 할 수 있습니다."
                }
            ]
        },
        ACCESS_DEVICE: {
            TITLE: "온라인 장치",
            CONTENT: [
                {
                    type: "name",
                    title: "디바이스 이름",
                    content: "연결된 장치의 이름을 표시합니다."
                }, {
                    type: "name",
                    title: "IP 주소",
                    content: "연결된 장치의 IP 주소를 표시합니다."
                }, {
                    type: "name",
                    title: "MAC 주소",
                    content: "연결된 장치의 MAC 주소를 표시합니다."
                }, {
                    type: "name",
                    title: "연결 유형",
                    content: "연결된 장치의 연결 유형을 표시합니다."
                }, {
                    type: "step",
                    title: "장치를 차단합니다",
                    content: "디바이스 오라인 테이블에서 차단하려는 장치에 해당하는 Modify 열의 블랙 아이콘을 클릭하십시오."
                }, {
                    type: "step",
                    title: "여러 장치를 차단합니다",
                    content: "디바이스 오라인 테이블에서 차단하려는 모든 장치를 선택하고 테이블 위의 블랙을 클릭하십시오. 장치가 블랙 리스트 또는 화이트 리스트의 장치에 자동으로 추가됩니다."
                }
            ]
        },
        ACCESS_LIST: {
            TITLE: "블랙 / 화이트리스트 디바이스",
            CONTENT: [
                {
                    type: "step",
                    title: "기기를 블랙리스트에나 화이트리스트에 올립니다.",
                    content: ["1. 추가 아이콘을 클릭하십시오.", "2. 장치 이름을 입력하십시오.", "3. 장치의 MAC 주소를 입력하십시오.", "4. 확인을 클릭하십시오."]
                }, {
                    type: "step",
                    title: "블랙리스트나 화이트리스트에서 장치를 수정하거나 삭제합니다.",
                    content: "블랙 / 화이트리스트에서 수정 또는 삭제하려는 장치에 해당하는 수정 아이콘 또는 삭제 아이콘을 클릭합니다."
                }, {
                    type: "step",
                    title: "블랙리스트나 화이트리스트에서 여러 장치를 삭제합니다.",
                    content: "블랙 / 화이트리스트 에서 삭제하려는 모든 장치를 선택하고 목록 위의 삭제를 클릭하십시오."
                }
            ]
        },
        IPMAC_BIND_SETTING: {
            TITLE: "설정",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "ARP (Address Resolution Protocol) 바인딩은 IP 주소와 장치의 MAC 주소를 함께 바인딩하여 LAN에있는 특정 컴퓨터의 액세스를 제어하는 ​​데 유용합니다. ARP 바인딩은 또한 다른 장치가 특정 IP 주소를 사용하는 것을 방지합니다."
                }
            ]
        },
        IPMAC_BIND_ARP: {
            TITLE: "ARP 리스트",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "현재 연결된 디바이스의 MAC 및 IP 주소를 표시합니다."
                }, {
                    type: "name",
                    title: "ARP 항목 번호",
                    content: "공유기에 현재 연결되어있는 총 디바이스 수를 표시합니다."
                }, {
                    type: "name",
                    title: "MAC 주소",
                    content: "연결된 디바이스의 MAC 주소를 표시합니다."
                }, {
                    type: "name",
                    title: "IP 주소",
                    content: "연결된 디바이스에 할당 된 IP 주소를 표시합니다."
                }, {
                    type: "name",
                    title: "경계",
                    content: "MAC 주소와 IP 주소의 바인딩 여부를 나타냅니다."
                }, {
                    type: "name",
                    title: "수정",
                    content: "목록에서 해당 항목을 연동하거나 삭제제하는 옵션을 표시합니다."
                }, {
                    type: "note",
                    title: "참고",
                    content: "둘개  이상의 MAC 주소에 동일한 IP 주소를 바인드 할 수 없습니다."
                }
            ]
        },
        IPMAC_BIND_LIST: {
            TITLE: "바인딩 목록",
            CONTENT: [
                {
                    type: "step",
                    title: "ARP 바인딩을 사용하여 장치를 설정합니다",
                    content: [
                        "1. 추가를 클릭하십시오.",
                        "2. 장치의 MAC 주소를 입력하십시오.",
                        "3. 위의 MAC 주소에 바인드 할 IP 주소를 입력하십시오.",
                        "4.이 장치에 대한 설명을 입력하십시오. (선택 과목)",
                        "5. 사용을 선택하십시오.",
                        "6. 확인을 클릭하십시오."
                    ]
                }, {
                    type: "step",
                    title: "항목을 수정하거나 삭제합니다",
                    content: "바인딩 목록에서 수정 또는 삭제하려는 항목에 해당하는 수정 아이콘 또는 삭제 아이콘을 클릭하십시오."
                }, {
                    type: "step",
                    title: "여러 항목을 삭제합니다",
                    content: "바인딩 목록에서 삭제할 항목을 모두 선택하고 목록 위의 삭제를 클릭하십시오."
                }
            ]
        },
        IPV6: {
            TITLE: "인터넷",
            CONTENT: [
                {
                    type: "name",
                    title: "IPv6",
                    content: "공유기의 IPv6 기능을 활성화 (On) 또는 비활성화 (Off)하려면 선택합니다."
                }, {
                    type: "title",
                    title: "인터넷 연결 유형 : 고정 IP"
                }, {
                    type: "name",
                    title: "고정 IP",
                    content: "ISP가 고정 IPv6 주소 할당을 사용하는 경우이 유형을 선택하십시오."
                }, {
                    type: "name",
                    title: "IPv6 주소 / 기본 게이트웨이 / 기본 DNS / 보조 DNS",
                    content: "ISP가 제공 한대로 이 매개 변수를 입력하십시오."
                }, {
                    type: "name",
                    title: "MTU 크기",
                    content: "대부분의 이더넷 네트워크의 기본 MTU (최대 전송 장치) 크기는 1500 바이트입니다. ISP가 요구하지 않는 한 기본 MTU 크기를 변경하지 않는 것이 좋습니다."
                }, {
                    type: "title",
                    title: "인터넷 연결 유형 : 동적 IP"
                }, {
                    type: "name",
                    title: " 동적 IP",
                    content: "ISP가 동적 IPv6 주소 할당을 사용하는 경우이 유형을 선택하십시오."
                }, {
                    type: "name",
                    title: "IPv6 주소 / 기본 DNS / 보조 DNS",
                    content: "이 매개 변수는 ISP의 DHCPv6 서버에 의해 자동으로 할당됩니다."
                }, {
                    type: "name",
                    title: "새로 고침",
                    content: "이 버튼을 클릭하면 ISP의 DHCPv6 서버에서 새 IPv6 매개 변수를 가져올 수 있습니다."
                }, {
                    type: "name",
                    title: "해제",
                    content: "ISP에서 DHCPv6 서버에 의해 할당 된 모든 IPv6 주소를 해제하려면이 단추를 클릭하십시오."
                }, {
                    type: "name",
                    title: "IPv6 주소 얻기",
                    content: "ISP에 따라 \"비 임시 IPv6 주소 가져 오기\"또는 \"IPv6 접두어 위임 가져 오기\"를 선택하십시오."
                }, {
                    type: "name",
                    title: "DNS 주소",
                    content: "\"ISP에서 동적으로 가져 오기\"또는 \"다음 DNS 주소 사용\"을 선택하십시오. \"다음 DNS 주소 사용\"을 선택하면 ISP가 제공 한 DNS 주소를 수동으로 입력하십시오."
                }, {
                    type: "name",
                    title: "기본 DNS / 보조 DNS",
                    content: "이 매개 변수를 수동으로 입력하거나 ISP에서 동적으로 가져옵니다."
                }, {
                    type: "title",
                    title: "인터넷 연결 유형 : PPPoE"
                }, {
                    type: "name",
                    title: "PPPoE",
                    content: "ISP가 PPPoEv6를 사용하고 사용자 이름과 암호를 제공 할 경우이 유형을 선택하십시오"
                }, {
                    type: "name",
                    title: "사용자 이름 / 암호",
                    content: "ISP가 제공 한대로 이 매개 변수를 입력하십시오."
                }, {
                    type: "name",
                    title: "IPv6 주소",
                    content: "사용자 이름과 암호를 입력하고 연결을 클릭하면 ISP에서 DHCPv6 서버에 의해 자동으로 할당됩니다."
                }, {
                    type: "name",
                    title: "DNS 주소",
                    content: "\"ISP에서 동적으로 가져 오기\"또는 \"다음 DNS 주소 사용\"을 선택하십시오. \"다음 DNS 주소 사용\"을 선택하면 ISP가 제공 한 DNS 주소를 수동으로 입력하십시오."
                }, {
                    type: "name",
                    title: "IPv6 주소 얻기",
                    content: "ISP에 따라 \"비 임시\"또는 \"위임 접두사\"또는 \"ISP에서 지정\"을 선택하십시오. \"ISP에서 지정\"을 선택하면 ISP가 제공 한대로 IPv6 주소를 수동으로 입력해야합니다. \"비 임시\"또는 \"위임 접두사\"를 선택하면 IPv6 주소가 ISP의 DHCPv6 서버에 자동으로 할당됩니다.",
                    children: [
                        {
                            type: "name",
                            title: "비 임시",
                            content: "인터넷 서비스 공급자 (ISP)에서 DHCPv6 서버에 의한 비 임시 IPv6 주소 가져 오기"
                        }, {
                            type: "name",
                            title: "Prefix 위임",
                            content: "ISP의 DHCPv6 Server에 의해 접두사 위임 IPv6 주소를 가져오고 LAN의 클라이언트는 위임과 함께 IPv6 주소를 만듭니다."
                        }, {
                            type: "name",
                            title: "ISP에 의해 지정됨",
                            content: "ISP가 지정한 정적 IPv6 주소를 사용하십시오."
                        }
                    ]
                }, {
                    type: "name",
                    title: "연결",
                    content: "인터넷에 연결하려면 이 버튼을 클릭하십시오."
                }, {
                    type: "name",
                    title: "연결 끊기",
                    content: "인터넷에서 연결을 끊으려면 이 버튼을 클릭하십시오."
                }, {
                    type: "title",
                    title: "인터넷 연결 유형 : 6to4 터널"
                }, {
                    type: "name",
                    title: "6to4 터널",
                    content: "ISP가 6to4 배치를 사용하여 주소를 지정하는 경우이 유형을 선택하십시오."
                }, {
                    type: "name",
                    title: "IPv4 주소 / IPv4 서브넷 마스크 / IPv4 기본 게이트웨이 / 터널 주소",
                    content: "이러한 매개 변수는 연결을 클릭 한 후 WAN 포트의 IPv4 매개 변수에 의해 동적으로 생성됩니다."
                }, {
                    type: "name",
                    title: "DNS 서버 사용",
                    content: "이 옵션을 사용하려면 확인란을 선택하십시오. 그런 다음 ISP가 제공 한 기본 DNS / 보조 DNS를 입력하십시오."
                }, {
                    type: "name",
                    title: "연결",
                    content: "인터넷에 연결하려면 이 버튼을 클릭하십시오."
                }, {
                    type: "name",
                    title: "연결 끊기",
                    content: "인터넷에서 연결을 끊으려면 이 버튼을 클릭하십시오."
                }, {
                    type: "title",
                    title: "인터넷 연결 유형 : 6RD"
                }, {
                    type: "name",
                    title: " 6RD",
                    content: "ISP가 6RD 배치를 사용하고 IPv4 주소 및 IPv6 주소 접두어를 제공 할 경우이 유형을 선택하십시오."
                }, {
                    type: "name",
                    title: "구성 유형",
                    content: "ISP에 따라 6RD 채널 매개 변수를 구성하려면 자동 또는 수동을 선택하십시오. 아래의 기본 매개 변수가 ISP가 제공 한 매개 변수와 일치하면 자동을 선택할 수 있습니다. 그렇지 않으면 수동을 선택하고 ISP가 제공 한 매개 변수를 입력하십시오."
                }, {
                    type: "name",
                    title: "IPv4 마스크 길이 / 6RD 접두사 / 6RD 접두사 길이 / 테두리 응답 IPv4 주소",
                    content: "미리 설정된 매개 변수가 ISP가 제공 한 매개 변수와 일치하는지 확인하고 기본값을 유지하거나 ISP에서 제공 한대로 수동으로 입력하십시오."
                }, {
                    type: "title",
                    title: "인터넷 연결 유형 : DS-Lite"
                }, {
                    type: "name",
                    title: "DS-Lite",
                    content: "ISP가 DS-Lite 배포를 사용하고 AFTR 도메인 이름 또는 IPv6 주소를 제공하는 경우이 유형을 선택합니다. IPv6 네트워크에서 IPv4 트래픽 또는 IPv6 트래픽을 각각의 네트워크에서 통신하도록 IPv4에서 IPv6 터널을 설정합니다 ."
                }, {
                    type: "name",
                    title: "AFTR 이름",
                    content: "AFTR은 주소 패밀리 전환 라우터의 약자입니다. 이 필드에는 ISP가 제공 한 AFTR 도메인 이름 또는 IPv6 주소를 입력하십시오"
                }, {
                    type: "name",
                    title: "보조 연결",
                    content: "ISP에서 제공하는 보조 연결 유형을 선택하십시오.",
                    children: [
                        {
                            type: "name",
                            title: "동적 IP",
                            content: "ISP가 보조 연결 유형으로 동적 IP를 제공하고 IPv6 주소 / 기본 DNS / 보조 DNS 매개 변수가 ISP의 DHCPv6 서버에 의해 자동으로 할당되는 경우 선택하십시오."
                        }, {
                            type: "name",
                            title: "고정 IP",
                            content: "ISP가 고정 IPv6 주소 할당을 사용하는 경우이 유형을 선택하십시오."
                        }, {
                            type: "name",
                            title: "PPPoE",
                            content: "ISP가 보조 연결 유형으로 PPPoE를 제공하고 ISP가 제공 한대로 사용자 이름 / 암호를 입력하면 선택하십시오. 연결을 클릭하면 IPv6 주소가 자동으로 할당됩니다."
                        }
                    ]
                }, {
                    type: "title",
                    title: "인터넷 연결 유형 : 통과 (브리지)"
                }, {
                    type: "paragraph",
                    content: "ISP가 통과 (브리지) 네트워크 배포를 사용하는 경우이 유형을 선택합니다. 이 유형의 경우 매개 변수가 제공되지 않으며 구성이 필요 없습니다."
                }
            ]
        },
        IPV6_LAN: {
            TITLE: "LAN",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Pass Through (브릿지)를 제외하고 다른 6 가지 유형의 인터넷 연결에는 IPv4 LAN 매개 변수에 대한 구성이 동시에 필요합니다."
                }, {
                    type: "name",
                    title: "지정된 유형",
                    content: "ISP에 따라 적절한 것을 선택하십시오.",
                    children: [
                        {
                            type: "name",
                            title: "DHCPv6",
                            content: "LAN의 클라이언트에 IP 주소를 자동으로 할당합니다.",
                            children: [
                                {
                                    type: "name",
                                    title: "주소 접두사",
                                    content: "ISP가 제공 한 주소 접두어를 입력하십시오."
                                }, {
                                    type: "name",
                                    title: "해제 시간",
                                    content: "할당 된 IP 주소가 유효한 시간을 의미합니다. 기본값 인 86400 초를 유지하거나 ISP가 요구하는 경우 변경하십시오."
                                }, {
                                    type: "name",
                                    title: "주소",
                                    content: "ISP에서 DHCPv6 서버에 의해 자동으로 할당 된 IP 주소입니다."
                                }
                            ]
                        }, {
                            type: "name",
                            connector: " ",
                            title: "SLAAC+Stateless DHCP",
                            children: [
                                {
                                    type: "name",
                                    title: "주소 접두사",
                                    content: "ISP가 제공 한 주소 접두어를 입력하십시오"
                                }, {
                                    type: "name",
                                    title: "주소",
                                    content: "ISP에서 DHCPv6 서버에 의해 자동으로 할당 된 IP 주소입니다."
                                }
                            ]
                        }, {
                            type: "name",
                            connector: " ",
                            title: "SLAAC+RDNSS",
                            children: [
                                {
                                    type: "name",
                                    title: "주소 접두사",
                                    content: "ISP가 제공 한 주소 접두어를 입력하십시오."
                                }, {
                                    type: "name",
                                    title: "주소",
                                    content: "ISP에서 DHCPv6 서버에 의해 자동으로 할당 된 IP 주소입니다."
                                }
                            ]
                        }
                    ]
                }
            ]
        },
        IPV6_MAC_CLONE: {
            TITLE: "MAC 클론",
            CONTENT: [
                {
                    type: "name",
                    title: "기본 MAC 주소 사용",
                    content: "ISP가 할당 된 IP 주소를 MAC 주소에 바인딩하지 않는 경우 라우터의 기본 MAC 주소를 변경하지 마십시오."
                }, {
                    type: "name",
                    title: "현재 컴퓨터 MAC 주소 사용",
                    content: "ISP가 할당 된 IP 주소를 컴퓨터의 MAC 주소에 바인드 할 경우 라우터에 연결된 컴퓨터의 현재 MAC 주소를 복사하려면 선택합니다."
                }, {
                    type: "name",
                    title: "사용자 지정 MAC 주소 사용",
                    content: "ISP가 할당 된 IP 주소를 특정 MAC 주소에 바인딩하는 경우 MAC 주소를 수동으로 입력하십시오."
                }
            ]
        },
        TIME_SETTING: {
            TITLE: "시간 설정",
            CONTENT: [
                {
                    type: "step",
                    title: "시간을 자동으로 동기화합니다",
                    content: ["1. 드롭 다운 메뉴에서 로컬 <b> 표준 시간대 </b>를 선택하십시오.", "2. <b> NTP 서버 I </b> 필드에 원하는 NTP 서버의 IP 주소를 입력하십시오. (선택 과목)", "3. <b> NTP 서버 II </b> 필드에 두 번째 NTP 서버의 IP 주소를 입력하십시오. (선택 과목)", "4. <b> GMT 가져 오기 </b>를 클릭하십시오."]
                }, {
                    type: "step",
                    title: "날짜와 시간을 수동으로 설정합니다",
                    content: ["1. <b> 시간 설정 </b> 입력란에서 로컬 <b> 시간대 </b>를 선택하십시오.", "2. 현재 <b> 날짜 </b>를 입력하십시오.", "3. 현재 <b> 시간 </b>을 선택하십시오 (예 : 16:00:00은 04:00 PM입니다).", "4. <b> 저장 </b>을 클릭하십시오."]
                }
            ]
        },
        TIME_SETTING_DAYLIGHT: {
            TITLE: "서머 타임",
            CONTENT: [
                {
                    type: "step",
                    title: "서머 타임 설정",
                    content: ["1. <b> 서머 타임 사용 </b>을 선택하십시오.", "2. 현지 시간대에서 서머 타임 시간이 시작되는 올바른 <b> 시작 </b> 날짜와 시간을 선택하십시오.", "3. 서머 타임 시간이 현지 시간대에 끝나는 올바른 <b> 종료 </b> 날짜 및 시간을 선택하십시오.", "4. <b> 저장 </b>을 클릭하십시오."]
                }
            ]
        },
        DIGNOSTIC: {
            TITLE: "진단",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "공유기는 네트워크 연결 문제를 해결하는 데 도움이되는 Ping 및 Traceroute 도구를 제공합니다. Ping 도구는 대상 IP 주소 또는 도메인 이름으로 패킷을 보내고 송수신 된 패킷 수 및 왕복 시간과 같은 결과를 기록합니다. Traceroute 도구는 패킷을 대상 IP 주소 또는 도메인 이름으로 보내고 대상에 도달하기 위한 연속 홉수 및 시간을 표시합니다."
                }, {
                    type: "paragraph",
                    content: "IP 주소 나 도메인 이름 (예 : google.com, yahoo.com 등)을 사용하여 로컬 장치에 대해 ping 및 traceroute를 수행 할 수 있습니다."
                }, {
                    type: "step",
                    title: "Ping을 사용하여 진단합니다",
                    content: ["1. 대상 IP 주소 또는 도메인 이름을 입력하십시오.", "2. 화살표 아이콘을 클릭하여 고급 메뉴를 열고 핑 카운트 및 핑 패킷 크기를 지정합니다. (선택 과목)", "3. 시작을 클릭하십시오."]
                }, {
                    type: "step",
                    title: "Traceroute를 사용하여 진단합니다",
                    content: ["1. 대상 IP 주소 또는 도메인 이름을 입력하십시오.", "2. 화살표 아이콘을 클릭하여 고급 메뉴를 열고 Traceroute Max TTL (Time to Live) 필드에서 도달 할 홉수를 지정하십시오. 기본값은 20입니다. (선택 사항)", "3. 시작을 클릭하십시오."]
                }
            ]
        },
        FIRMWARE: {
            TITLE: "펌웨어 업그레이드",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "파워라인 익스텐더의 펌웨어를 업그레이드하기 전에 <a class = \"link\"href = \"http://www.tp-link.com/kr/support/\"target = \"_blank \"> TP-LINK Support </a> 웹 사이트를 방문하십시오."
                }, {
                    type: "step",
                    title: "중요 : 업그레이드 실패를 방지하려면 다음을 참고하십시오.",
                    content: ["최신 펌웨어 파일이 하드웨어 버전과 일치하는지 확인하십시오 (펌웨어 업그레이드 페이지 아래 참조).", "파워라인 익스텐더와 컴퓨터가 안정적으로 연결되어 있는지 확인하십시오. 펌웨어를 무선으로 업그레이드하는 것은 권장되지 않습니다.", "파워라인 익스텐더 구성을 백업하십시오.", "펌웨어 업그레이드 중에 전원 연장 케이블을 끄지 마십시오."]
                }, {
                    type: "step",
                    title: "파워라인 익스텐더의 펌웨어를 업그레이드합니다",
                    content: ["1. <b> 찾아보기 </b>를 클릭하십시오.", "2. 다운로드 한 펌웨어 파일을 찾아서 선택하십시오.", "3. <b> 업그레이드 </b>를 클릭하십시오."]
                }, {
                    type: "paragraph",
                    content: "업그레이드 프로세스를 완료하는 데 몇 분이 걸립니다. 업그레이드 과정 중에 파워 라인 익스텐더의 전원을 끄지 마십시오."
                }
            ]
        },
        FIRMWARE_UPGRADE_ONLINE: {
            TITLE: "온라인으로 펌웨어를 업그레이드합니다",
            CONTENT: [
                {
                    type: "paragraph",
                    content: ["업그레이드를 클릭하고 메시지가 나타나면 예를 클릭하면 확장기가 자동으로 최신 펌웨어 파일을 다운로드하여 업그레이드를 합니다. 또한 업그레이드 확인을 클릭하여 최신 버전을 확인할 수 있습니다."]
                }
            ]
        },
        FIRMWARE_UPGRADE: {
            TITLE: "펌웨어를 수동으로 업그레이드합니다",
            CONTENT: [
                {
                    type: "step",
                    content: ["1. 페이지 하단의 지원을 클릭하고 최신 펌웨어를 컴퓨터에 다운로드하십시오. 다운로드하려는 펌웨어 파일이 페이지에 표시된 라우터의 하드웨어 버전과 일치하는지 확인하십시오.", "2. 찾아보기를 클릭하고 다운로드 한 펌웨어 파일을 선택하십시오.", "3. 업그레이드를 클릭하십시오."]
                }, {
                    type: "paragraph",
                    content: ["펌웨어 업그레이드를 완료하는 데 몇 분 정도 걸립니다. 펌웨어 업그레이드가 완료되면 확장기가 자동으로 재부팅됩니다."]
                }
            ]
        },
        BACKUP: {
            TITLE: "백업",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "시스템을 이전 상태 또는 공장 기본값으로 복원하기 위해 복구가 필요한 경우에 대비하여 현재 구성을 백업하는 것이 좋습니다."
                }, {
                    type: "paragraph",
                    content: "현재 구성을 컴퓨터에 저장하려면 <b> 백업 </b>을 클릭하십시오. 필요할 경우 나중에 Extender를 검색하고 복원 할 수있는 안전한 위치에 백업 파일을 저장하십시오."
                }
            ]
        },
        RESTORE: {
            TITLE: "복원",
            CONTENT: [
                {
                    type: "step",
                    title: "백업에서 복원합니다",
                    content: ["1. <b> 찾아보기 </b>를 클릭하십시오.", "2. 백업 파일을 찾아서 선택하십시오.", "3. <b> 복원 </b>을 클릭하십시오."]
                }
            ]
        },
        FACTORY: {
            TITLE: "초기 기본값 복원",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "<b> 기본 설정 복원 </b>을 클릭하여 기본 설정으로 전원 확장 장치를 재설정하십시오."
                }, {
                    type: "note",
                    title: "참고",
                    content: ["1. 공장 초기화는 파워라인 익스텐더에 대해 설정 한 모든 설정을 지울 것입니다. 익스텐더의 관리 페이지로 다시 로그인하려면 사용자 이름과 비밀번호 모두에 기본 <b> admin </ b>을 사용하십시오.", "2. 백업 또는 복원 과정 중에 익스텐더의 전원을 끄지 마십시오."]
                }
            ]
        },
        ADMIN_ACCOUNT: {
            TITLE: "계정 관리",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "이 페이지에서 로그인 사용자 이름 및 / 또는 암호를 변경할 수 있습니다."
                }, {
                    type: "name",
                    title: "이전 사용자 이름",
                    content: "현재 사용자 이름을 입력하십시오."
                }, {
                    type: "name",
                    title: "기존 비밀번호",
                    content: "현재 비밀번호를 입력하십시오."
                }, {
                    type: "name",
                    title: "새 사용자 이름",
                    content: "새 사용자 이름을 입력하십시오."
                }, {
                    type: "name",
                    title: "새 비밀번호",
                    content: "새 암호를 입력하십시오."
                }, {
                    type: "name",
                    title: "새 암호를 확인합니다",
                    content: "새 암호를 다시 입력하십시오."
                }, {
                    type: "note",
                    title: "참고",
                    content: "파워라인 익스텐더에 로그인하는 데 사용되는 현재 사용자 이름과 암호를 변경하는 경우 새 로그인 정보가 안전한 위치에 기록되어 있는지 확인하십시오. 강력한 암호는 8 자 이상이어야하며 대문자와 소문자, 숫자 및 구두점을 조합해야합니다."
                }, {
                    type: "paragraph",
                    content: "<b> 저장 </b>을 클릭하여 모든 설정을 저장하십시오."
                }
            ]
        },
        ADMIN_RECOVERY: {
            TITLE: "비밀번호 복구",
            CONTENT: [
                {
                    type: "name",
                    title: "비밀번호 복구 사용",
                    content: "암호 복구 기능을 사용하면 분실하거나 잊어 버린 사용자 이름과 암호를 전자 메일로 보낼 수 있습니다."
                }, {
                    type: "name",
                    title: "에서",
                    content: "보내는 전자 메일에 사용할 유효한 전자 메일 주소를 입력하십시오."
                }, {
                    type: "name",
                    title: "에",
                    content: "수신 이메일에 사용할 유효한 이메일 주소를 입력하십시오."
                }, {
                    type: "name",
                    title: "SMTP 서버",
                    content: "라우터가 전자 메일을 통해 계정 정보를 보내는 데 사용하는 SMTP 서버 주소를 입력합니다."
                }, {
                    type: "name",
                    title: "인증 사용",
                    content: "보내는 전자 메일 서버에서 전자 메일을 보내기위한 인증이 필요한 경우 사용자 이름과 암호를 해당 필드에 입력합니다. 이 필드는 대소 문자를 구분합니다."
                }
            ]
        },
        ADMIN_LOCAL: {
            TITLE: "로컬 관리",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "이 섹션에서는 MAC 주소 기반 인증을 사용하여 LAN상의 클라이언트 장치 수가 라우터에 액세스하는 것을 제한 할 수 있습니다."
                }, {
                    type: "name",
                    title: "모든 LAN 연결 장치에 대한 액세스",
                    content: "모든 LAN 연결 장치에 대해 로컬 관리를 사용하려면 On으로 설정하고 특정 장치에 대한 관리를 사용하려면 Off로 토글하십시오."
                }, {
                    type: "name",
                    title: "MAC 주소",
                    content: "제한된 액세스 장치의 MAC 주소를 표시합니다."
                }, {
                    type: "name",
                    title: "설명",
                    content: "제한 액세스 장치의 설명을 표시합니다."
                }, {
                    type: "name",
                    title: "상태",
                    content: "제한된 액세스 장치의 현재 상태 (활성화 또는 비활성화)를 표시합니다."
                }, {
                    type: "name",
                    title: "수정",
                    content: "목록에서 해당 장치를 수정 및 삭제하는 옵션을 표시합니다."
                }, {
                    type: "step",
                    title: "목록에 클라이언트 장치를 추가합니다",
                    content: ["1. 추가를 클릭하십시오.", "2. 기존 장치보기를 클릭하여 기존 장치를 선택하거나 MAC 주소 필드에 장치의 MAC 주소를 입력합니다.", "3. 장치에 대한 설명을 입력하십시오. (선택 과목)", "4. 사용을 선택하십시오.", "5. 확인을 클릭하십시오."]
                }, {
                    type: "step",
                    title: "목록에서 장치를 수정하거나 삭제합니다",
                    content: "수정 또는 삭제하려는 장치에 해당하는 수정 아이콘 또는 삭제 아이콘을 클릭하십시오."
                }, {
                    type: "step",
                    title: "여러 디바이스를 삭제합니다",
                    content: "삭제할 모든 디바이스를 선택하여 삭제를 클릭하십시오."
                }
            ]
        },
        ADMIN_REMOTE: {
            TITLE: "원격 관리",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "원격 관리 기능을 사용하면 인터넷에서 공유기를 원격으로 액세스하고 구성 할 수 있습니다."
                }, {
                    type: "name",
                    title: "원격 관리 사용 안 함",
                    content: "원격 관리를 사용하지 않으려면 이 옵션을 선택하십시오."
                }, {
                    type: "name",
                    title: "모든 장치에 대해 원격 관리 사용",
                    content: "모든 IP 주소에 대해 원격 관리를 사용하려면 이 옵션을 선택합니다. 선택하는 경우 웹 관리 포트 필드를 입력하십시오."
                }, {
                    type: "name",
                    title: "지정된 장치에 대한 원격 관리 사용",
                    content: "특정 IP 주소에 대해 원격 관리를 활성화하려면 이 옵션을 선택합니다. 선택하는 경우 웹 관리 포트 및 원격 관리 IP 주소 필드를 입력하십시오."
                }, {
                    type: "name",
                    title: "웹 관리 포트",
                    content: "보안 수준이 높은 라우터의 웹 관리 인터페이스에 액세스하는 데 사용되는 1024 - 65535 사이의 포트 번호를 입력하십시오. 일반적으로 웹 브라우저는 표준 HTTP 서비스 포트 80을 사용합니다. 기본 및 공통 서비스 포트는 HTTP의 대체 서비스 포트 인 8080입니다."
                }, {
                    type: "name",
                    title: "원격 관리 IP 주소",
                    content: "공유기에 액세스 할 수 있도록 유효한 IP 주소 또는 IP 범위를 입력하십시오. 255.255.255.255를 입력하면 모든 사용자가 액세스 할 수 있습니다."
                }
            ]
        },
        SYSTEM_LOG: {
            TITLE: "시스템 로그",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "시스템 로그 페이지에는 익스텐더의 가장 최근 활동 (이벤트) 목록이 표시됩니다. 보려는 로그 유형 및 / 또는 로그 유형을 정의 할 수 있습니다."
                }, {
                    type: "name",
                    title: "타입",
                    content: "표시 할 시스템 로그 유형을 선택하십시오."
                }, {
                    type: "name",
                    title: "레벨",
                    content: "표시 할 시스템 로그의 레벨을 선택하십시오."
                }, {
                    type: "name",
                    title: "새로 고침",
                    content: "이 아이콘을 클릭하면 시스템 로그가 업데이트됩니다."
                }, {
                    type: "name",
                    title: "모두 삭제",
                    content: "모든 시스템 로그를 삭제하려면 이 아이콘을 클릭하십시오."
                }, {
                    type: "name",
                    title: "로그 저장",
                    content: "이 버튼을 클릭하여 시스템 로그 파일을 로컬 컴퓨터로 다운로드하십시오."
                }
            ]
        },
        TRAFFIC_STATISTIC: {
            TITLE: "트래픽 통계",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "트래픽 통계 페이지는 LAN, WAN 및 WLAN 패킷 송수신의 네트워크 트래픽을 표시합니다."
                }, {
                    type: "note",
                    title: "참고",
                    content: "NAT Boost가 활성화되면 트래픽 통계를 비활성화해야합니다."
                }, {
                    type: "name",
                    title: "트래픽 통계",
                    content: "기본적으로 트래픽 통계는 Off입니다. 통계 정보를 표시하려면 On을 클릭하십시오."
                }
            ]
        },
        TRAFFIC_STATISTIC_LIST: {
            TITLE: "트래픽 통계 목록",
            CONTENT: [
                {
                    type: "name",
                    title: "IP 주소 / MAC 주소",
                    content: "연결된 클라이언트 장치의 IP 주소 및 MAC 주소를 표시합니다."
                }, {
                    type: "name",
                    title: "총 패킷 수",
                    content: "세션이 시작되거나 마지막 카운터가 재설정 된 이후에 클라이언트 장치가 송수신 한 총 패킷 수를 표시합니다."
                }, {
                    type: "name",
                    title: "총 바이트 수",
                    content: "세션이 시작되거나 마지막 카운터가 재설정 된 이후에 클라이언트 장치가 송수신 한 총 바이트 수를 표시합니다."
                }, {
                    type: "name",
                    title: "현재 패킷",
                    content: "특정 시간 간격으로 전송 및 수신 된 현재 패킷 수를 표시합니다."
                }, {
                    type: "name",
                    title: "현재 바이트",
                    content: "특정 시간 간격으로 전송 및 수신 된 현재 바이트 수를 표시합니다."
                }, {
                    type: "name",
                    title: "현재 ICMP Tx",
                    content: "초당 WAN 포트를 통해 전송 된 ICMP 패킷의 현재 전송 속도 및 최대 전송 속도를 표시합니다."
                }, {
                    type: "name",
                    title: "현재 UDP Tx",
                    content: "초당 WAN 포트를 통해 전송 된 UDP 패킷의 현재 전송 속도 및 최대 전송 속도를 표시합니다."
                }, {
                    type: "name",
                    title: "현재 SYN Tx",
                    content: "초당 WAN 포트를 통해 전송 된 TCP SYN 패킷의 현재 전송 속도 및 최대 전송 속도를 표시합니다."
                }, {
                    type: "name",
                    title: "수정",
                    content: "재설정 (0) 옵션과 해당 통계를 목록에서 삭제합니다."
                }, {
                    type: "name",
                    title: "새로 고침",
                    content: "페이지의 통계 정보를 업데이트하려면 클릭하십시오."
                }, {
                    type: "name",
                    title: "모두 리셋",
                    content: "목록의 모든 통계 값을 0으로 재설정하려면 클릭하십시오."
                }, {
                    type: "name",
                    title: "모두 삭제",
                    content: "목록의 모든 통계 정보를 삭제하려면 누릅니다."
                }
            ]
        },
        SYSTEM_PARA_WIRELESS: {
            TITLE: "무선 2.4GHz / 5GHz",
            CONTENT: [
                {
                    type: "name",
                    title: "비콘 간격",
                    content: "공유기가 무선 네트워크를 동기화하기 위해 브로드 캐스팅하는 비콘 패킷 간의 간격을 확인하려면 밀리 초 단위로 40 - 1000 사이의 값을 입력하십시오. 기본값은 100 밀리 초입니다."
                }, {
                    type: "name",
                    title: "RTS 임계 값",
                    content: "공유기를 통한 데이터 전송의 패킷 크기를 결정하려면 1에서 2346 사이의 값을 입력하십시오. 기본적으로 RTS (Request to Send) 임계 값 크기는 2346입니다. 패킷 크기가 사전 설정된 임계 값보다 큰 경우 공유기는 특정 수신 스테이션에 프레임 전송 요청을 보내고 데이터 프레임의 전송을 협상합니다. 패킷이 즉시 전송됩니다."
                }, {
                    type: "name",
                    title: "DTIM 간격",
                    content: "이 값은 배달 트래픽 표시 메시지 (DTIM)의 간격을 결정합니다. 밀리 초 단위로 1 - 15 사이의 값을 입력하십시오. 기본값은 1이며 DTIM 간격이 비콘 간격과 동일 함을 나타냅니다."
                }, {
                    type: "name",
                    title: "그룹 키 업데이트 기간",
                    content: "암호화 키 자동 갱신을 위한 시간 간격을 제어하는 초 수 (최소 30)를 입력하십시오. 기본값은 0이며 키 갱신이 없음을 나타냅니다."
                }, {
                    type: "name",
                    title: "WMM 기능",
                    content: "WMM 기능은 우선 순위가 높은 메시지가 우선적으로 전송되는 패킷을 보장합니다. 기본적으로 사용하도록 설정되어 있으므로 적극 권장합니다."
                }, {
                    type: "name",
                    title: "짧은 GI 기능",
                    content: "이 기능은 기본적으로 활성화되어 있으며 Guard Interval (GI) 시간을 줄여 데이터 용량을 늘리는 것이 좋습니다."
                }, {
                    type: "name",
                    title: "AP 절연 기능",
                    content: "기본적으로이 기능은 비활성화되어 있습니다. 네트워크에 연결된 모든 무선 장치를 제한하고 제한하고 싶지만 인터넷에 계속 액세스 할 수있게 하려면 AP 격리 사용 확인란을 선택합니다."
                }, {
                    type: "name",
                    title: "WDS 브릿징",
                    content: "공유기가 무선 근거리 통신망 (WLAN)의 다른 액세스 지점 (AP)과 연결될 수 있도록 WDS (무선 분배 시스템) 브리징 기능을 활성화합니다. 이 기능을 사용하는 경우 다음을 구성하십시오.",
                    children: [
                        {
                            type: "name",
                            title: "SSID",
                            content: "공유기가 클라이언트로 연결할 WAP (무선 액세스 포인트)의 SSID를 입력하거나 측량 기능을 사용하여 현재 채널에서 사용 가능한 모든 네트워크를 찾습니다."
                        }, {
                            type: "name",
                            title: "측량",
                            content: "범위 내에있는 사용 가능한 모든 무선 네트워크의 SSID, BSSID, 신호 강도, 채널 및 보안 정보를 스캔하고 표시하려면 이 버튼을 클릭하십시오. 네트워크를 선택하면 SSID, MAC 주소 및 보안이 자동으로 채워집니다."
                        }, {
                            type: "name",
                            title: "MAC 주소 (브리지 됨)",
                            content: "공유기가 클라이언트로 연결할 무선 액세스 포인트의 하이픈으로 구분 된 12 자리 16 진수 (0-9, a-f, A-F) 형식의 MAC 주소 (BSSID)를 입력하십시오. 측량 기능을 통해 원하는 AP를 선택하면 MAC 주소 필드가 자동으로 입력됩니다."
                        }, {
                            type: "name",
                            title: "보안",
                            content: "선택한 액세스 포인트의 올바른 보안 유형, 아니요, WPA-PSK / WPA2-PSK 또는 WEP를 선택합니다. 측량 기능을 통해 원하는 AP를 선택하면 보안 필드가 자동으로 채워집니다.",
                            children: [
                                {
                                    type: "name",
                                    title: "암호",
                                    content: "이 옵션은 보안 유형이 WPA-PSK / WPA2-PSK 또는 WEP 일 때 사용할 수 있습니다. 선택한 액세스 포인트의 보안 암호를 입력하십시오."
                                }, {
                                    type: "name",
                                    title: "Auth. 유형",
                                    content: "이 옵션은 보안 유형이 WEP (Wired Equivalent Privacy) 인 경우에만 사용할 수 있습니다. 선택한 액세스 포인트에서 사용되는 적절한 인증 유형 (자동, 개방형 시스템 또는 공유 키)을 선택하십시오."
                                }, {
                                    type: "name",
                                    title: "WEP 키 형식",
                                    content: "이 옵션은 보안 유형이 WEP 인 경우에만 사용할 수 있습니다. 선택한 AP의 키 형식 (ASCII 또는 16 진수)을 선택하십시오."
                                }
                            ]
                        }
                    ]
                }, {
                    type: "paragraph",
                    content: "저장을 클릭하여 설정을 저장하십시오."
                }
            ]
        },
        SYSTEM_PARA_WPS: {
            TITLE: "WPS",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "WPS 사용 확인란을 선택하고 저장을 클릭하여 버튼을 눌러 WPS 지원 장치를 쉽게 설정하고 연결할 수있는 WPS (Wi-Fi Protected Setup) 기능을 활성화합니다."
                }
            ]
        },
        SYSTEM_PARA_NAT: {
            TITLE: "NAT",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "NAT 사용 확인란을 선택하고 저장을 클릭하여 NAT (네트워크 주소 변환) 기능을 사용합니다."
                }, {
                    type: "name",
                    title: "NAT 부스트",
                    content: "Enable NAT Boost 체크 박스를 선택하고 저장을 클릭하여 공유기의 처리량이 최대치 되도록하십시오."
                }, {
                    type: "note",
                    title: "참고",
                    content: "QoS 또는 트래픽 통계가 활성화되면 NAT 부스트가 비활성화됩니다."
                }
            ]
        },
        SYSTEM_PARA_DOS: {
            TITLE: "DoS 보호 수준 설정",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "DoS 보호 수준은 TCP-SYN-Flood, UDP-Flood 및 ICMP-Flood 공격으로부터 라우터를 보호합니다."
                }, {
                    type: "name",
                    title: "ICMP-FLOOD 패킷 레벨",
                    content: "패킷 수가 미리 설정된 임계 값을 초과하면 ICMP-FLOOD 보호를 트리거하는 5 ~ 7200 ICMP 패킷 사이의 값을 입력하십시오."
                }, {
                    type: "name",
                    title: "UDP-FLOOD 패킷 레벨",
                    content: "패킷 수가 미리 설정된 임계 값을 초과하면 UDP-FLOOD 보호를 트리거하는 5 ~ 7200 UDP 패킷 사이의 값을 입력하십시오."
                }, {
                    type: "name",
                    title: "TCP-FLOOD 패킷 레벨",
                    content: "패킷 수가 미리 설정된 임계 값을 초과하면 TCP-SYN-FLOOD 보호를 트리거하려면 5 - 7200 TCP-SYN 패킷 사이의 값을 입력하십시오."
                }, {
                    type: "paragraph",
                    content: "저장을 클릭하여 설정을 저장하십시오."
                }
            ]
        },
        SYSTEM_PARA_DUPLEX: {
            TITLE: "듀플렉스",
            CONTENT: [
                {
                    type: "name",
                    title: "듀플렉스",
                    content: "드롭 다운 목록에서 양면 인쇄 유형을 선택하십시오."
                }, {
                    type: "paragraph",
                    content: "저장을 클릭하여 설정을 저장하십시오."
                }
            ]
        },
        BASIC_NETWORK_INTEREST: {
            TITLE: "인터넷",
            CONTENT: [
                {
                    type: "name",
                    title: "인터넷 상태",
                    content: "라우터의 인터넷 연결 상태를 표시합니다."
                }, {
                    type: "name",
                    title: "연결 유형",
                    content: "인터넷 연결 유형을 표시합니다."
                }, {
                    type: "name",
                    title: "IP 주소",
                    content: "라우터에 할당 된 현재 인터넷 IP 주소를 표시합니다."
                }, {
                    type: "name",
                    title: "보조 연결 / IP 주소",
                    content: "보조 연결 유형 및 IP 주소를 표시합니다."
                }
            ]
        },
        BASIC_NETWORK_ROUTER: {
            TITLE: "공유기",
            CONTENT: [
                {
                    type: "title",
                    title: "무선 2.4GHz / 5GHz"
                }, {
                    type: "name",
                    title: "SSID",
                    content: "2.4GHz / 5GHz 대역 주파수의 현재 무선 네트워크 이름을 표시합니다."
                }, {
                    type: "name",
                    title: "채널",
                    content: "무선 2.4GHz / 5GHz 네트워크가 브로드 캐스트하는 채널을 표시합니다."
                }, {
                    type: "name",
                    title: "MAC",
                    content: "무선 2.4GHz / 5GHz의 현재 MAC 주소를 표시합니다."
                }, {
                    type: "title",
                    title: "2.4GHz / 5GHz 무선 네트워크"
                }, {
                    type: "name",
                    title: "상태",
                    content: "무선 게스트 네트워크 2.4GHz / 5GHz가 켜져 있는지 (사용) 또는 꺼져 있는지 (사용하지 않음) 여부를 표시합니다."
                }, {
                    type: "name",
                    title: "SSID",
                    content: "게스트 네트워크의 무선 네트워크 이름을 표시합니다."
                }
            ]
        },
        BASIC_NETWORK_CLIENTS: {
            TITLE: "무선 / 유선 클라이언트",
            CONTENT: [
                {
                    type: "name",
                    title: "이름",
                    content: "공유기에 연결된 클라이언트의 이름을 표시합니다."
                }, {
                    type: "name",
                    title: "IP 주소",
                    content: "클라이언트의 할당 된 IP 주소를 표시합니다."
                }, {
                    type: "name",
                    title: "MAC 주소",
                    content: "클라이언트의 MAC 주소를 표시합니다."
                }
            ]
        },
        BASIC_NETWORK_PRINTER: {
            TITLE: "프린터",
            CONTENT: [
                {
                    type: "name",
                    title: "이름",
                    content: "공유기에 연결된 프린터의 이름을 USB 포트를 통해 표시합니다."
                }
            ]
        },
        BASIC_NETWORK_USB: {
            TITLE: "USB 디스크",
            CONTENT: [
                {
                    type: "name",
                    title: "USB 디스크",
                    content: "공유기에 연결된 USB 디스크의 브랜드를 표시합니다."
                }, {
                    type: "name",
                    title: "합계",
                    content: "USB 디스크의 총 볼륨을 표시합니다."
                }, {
                    type: "name",
                    title: "유효",
                    content: "USB 디스크의 사용 가능한 공간을 표시합니다."
                }
            ]
        },
        BASIC_INTERNET: {
            TITLE: "인터넷",
            CONTENT: [
                {
                    type: "name",
                    title: "자동 감지",
                    content: "이 단추를 클릭하면 라우터가 현재 인터넷 연결 유형을 자동으로 감지합니다."
                }, {
                    type: "note",
                    title: "노트",
                    content: "가지고있는 인터넷 연결 유형을 잘 모르는 경우, 자동 감지 기능을 사용하거나 ISP에 도움을 요청하십시오."
                }, {
                    type: "title",
                    title: "인터넷 연결 유형 : 정적 IP"
                }, {
                    type: "name",
                    title: "IP 주소 / 서브넷 마스크 / 기본 게이트웨이 / 기본 DNS / 보조 DNS",
                    content: "ISP가 제공 한 정보를 입력하십시오."
                }, {
                    type: "title",
                    title: "인터넷 연결 유형 : 동적 IP"
                }, {
                    type: "name",
                    title: "MAC 주소 복제 안 함 / 현재 컴퓨터 MAC 주소 복제",
                    content: "ISP에 따라 MAC 주소를 복제할지 여부를 선택하십시오."
                }, {
                    type: "title",
                    title: "인터넷 연결 유형 : PPPoE"
                }, {
                    type: "name",
                    title: "사용자 이름 / 암호",
                    content: "ISP가 제공 한 사용자 이름과 암호를 입력하십시오. 이 필드는 대소 문자를 구분합니다."
                }, {
                    type: "title",
                    title: "인터넷 연결 유형 : L2TP / PPTP"
                }, {
                    type: "name",
                    title: "사용자 이름 / 암호",
                    content: "ISP가 제공 한 사용자 이름과 암호를 입력하십시오. 이 필드는 대소 문자를 구분합니다."
                }, {
                    type: "name",
                    title: "보조 연결 (유동 IP 또는 고정 IP)",
                    children: [
                        {
                            type: "name",
                            title: "동적 IP",
                            content: "IP 주소 및 서브넷 마스크가 ISP에 의해 자동으로 할당되는 경우 선택하십시오."
                        }, {
                            type: "name",
                            title: "고정 IP",
                            content: "ISP가 IP 주소, 서브넷 마스크, 게이트웨이 및 DNS 주소를 제공하는지 여부를 선택하고 해당 정보를 해당 필드에 입력하십시오."
                        }
                    ]
                }, {
                    type: "name",
                    title: "VPN 서버 IP / 도메인 이름",
                    content: "ISP가 제공 한 VPN 서버의 IP 주소 또는 도메인 이름을 입력하십시오."
                }
            ]
        },
        BASIC_WIRELESS: {
            TITLE: "무선 설정",
            CONTENT: [
                {
                    type: "name",
                    title: "무선 라디오 사용",
                    content: "2.4GHz / 5GHz 무선 라디오 주파수를 활성화하려면이 확인란을 선택합니다."
                }, {
                    type: "name",
                    title: "무선 네트워크 이름 (SSID)",
                    content: "기본 무선 네트워크 이름 (SSID)은 그대로 두거나 새 이름을 입력 할 수 있습니다 (최대 32 자). 이 필드는 대소 문자를 구분합니다."
                }, {
                    type: "name",
                    title: "SSID 숨기기",
                    content: "Wi-Fi 네트워크 목록에서 2.4GHz / 5GHz 네트워크 이름 (SSID)을 숨기려면이 확인란을 선택합니다."
                }, {
                    type: "name",
                    title: "비밀번호",
                    content: "이 암호는 8 ~ 63 자의 ASCII 문자 또는 8 ~ 64 자의 16 진수로 구성됩니다 (대소 문자 구분)."
                }
            ]
        },
        BASIC_DEVICE_SETTINGS: {
            TITLE: "디바이스 설정",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "장치 설정 페이지에는 USB 포트를 통해 연결된 USB 저장 장치의 관련 정보가 표시됩니다."
                }, {
                    type: "name",
                    title: "스캔",
                    content: "일반적으로 라우터는 새로 연결된 장치를 자동으로 감지합니다. 그렇지 않은 경우이 단추를 클릭하여 연결된 새 장치를 검색하고 업데이트 된 정보로 페이지를 새로 고칩니다."
                }, {
                    type: "name",
                    title: "볼륨",
                    content: "USB 볼륨의 이름을 표시합니다."
                }, {
                    type: "name",
                    title: "용량",
                    content: "USB의 총 저장 용량을 표시합니다."
                }, {
                    type: "name",
                    title: "사용 가능 공간",
                    content: "사용 가능한 현재 사용 가능한 저장 공간을 표시합니다."
                }, {
                    type: "name",
                    title: "안전 제거",
                    content: "USB 저장 장치를 실제로 연결 해제하기 전에 USB 저장 장치를 안전하게 분리하려면이 단추를 클릭하십시오.",
                    children: [
                        {
                            type: "paragraph",
                            content: "안전하게 제거 버튼은 라우터에 USB 저장 장치가 연결된 경우에만 나타납니다. 또한 현재 볼륨이 사용중인 동안에는 USB 장치를 마운트 해제 할 수 없습니다."
                        }
                    ]
                }, {
                    type: "name",
                    title: "유효",
                    content: "이 체크 박스는 라우터에 연결된 USB 저장 장치가있는 경우에만 나타납니다. USB 장치의 파일 공유를 활성화하려면 선택합니다."
                }
            ]
        },
        BASIC_SHARING_SETTINGS: {
            TITLE: "공유 설정",
            CONTENT: [
                {
                    type: "name",
                    title: "네트워크 / 미디어 서버 이름",
                    content: "연결된 USB 저장 장치에 액세스하는 데 사용 된 이름을 표시합니다."
                }
            ]
        },
        BASIC_FOLDER_SHARING: {
            TITLE: "폴더 공유",
            CONTENT: [
                {
                    type: "name",
                    title: "모두 공유",
                    content: "모든 파일 및 폴더를 공유하려면 켜짐으로 전환하고, 선택한 폴더 만 공유하려면 끄기로 전환하십시오."
                }, {
                    type: "name",
                    title: "인증 사용",
                    content: "사용자가 공유 폴더에 액세스하려면 유효한 사용자 이름과 암호를 입력하도록 인증을 사용하도록 설정하는 것이 좋습니다."
                }, {
                    type: "name",
                    title: "폴더 이름",
                    content: "공유 폴더의 이름을 표시합니다."
                }, {
                    type: "name",
                    title: "폴더 경로",
                    content: "공유 폴더의 경로를 표시합니다."
                }, {
                    type: "name",
                    title: "미디어 공유",
                    content: "공유 폴더에서 미디어 공유가 허용되는지 여부를 나타냅니다."
                }, {
                    type: "name",
                    title: "볼륨 이름",
                    content: "공유 볼륨의 이름을 표시합니다."
                }, {
                    type: "name",
                    title: "지위",
                    content: "전구 표시기로 공유 폴더의 상태를 표시합니다. 녹색 (ON)이 활성화되고 회색 (OFF)이 비활성화됩니다. 전구를 클릭하여 공유를 활성화 또는 비활성화 할 수 있습니다."
                }, {
                    type: "name",
                    title: "수정",
                    content: "해당 공유 폴더 수정 및 삭제 옵션을 표시합니다."
                }, {
                    type: "name",
                    title: "더하다",
                    content: "새 항목을 만들려면이 단추를 클릭하십시오."
                }, {
                    type: "name",
                    title: "지우다",
                    content: "선택한 항목을 테이블에서 제거하려면이 단추를 누르십시오."
                }, {
                    type: "name",
                    title: "검색",
                    content: "공유 폴더를 검색하려면 클릭하십시오."
                }, {
                    type: "name",
                    title: "게스트 네트워크 액세스 허용",
                    content: "게스트 네트워크의 클라이언트가 공유 폴더에 액세스 할 수있게하려면 선택하십시오."
                }, {
                    type: "name",
                    title: "인증 사용",
                    content: "사용자가 유효한 사용자 이름과 암호로 공유 폴더에 액세스하도록 요구할 때 선택하십시오."
                }, {
                    type: "name",
                    title: "쓰기 액세스 사용",
                    content: "사용자가 폴더 내용을 변경할 수있게하려면 선택하십시오."
                }, {
                    type: "name",
                    title: "미디어 공유 사용",
                    content: "미디어 공유를 활성화하려면 선택하십시오."
                }
            ]
        },
        BASIC_PRINT_SERVER: {
            TITLE: "프린터 서버",
            CONTENT: [
                {
                    type: "name",
                    title: "프린터 서버 사용",
                    content: "켜기를 클릭하여 프린트 서버 기능을 활성화하십시오."
                }, {
                    type: "name",
                    title: "프린터 이름",
                    content: "공유기에 연결된 프린터의 이름을 표시합니다."
                }, {
                    type: "step",
                    title: "네트워크에서 사용할 수있는 프린터 서버를 설정합니다",
                    content: ["1. USB 프린터를 USB 케이블을 통해 공유기의 USB 포트에 연결하십시오.", "2. 컴퓨터에 프린터 드라이버를 설치하십시오. 컴퓨터 제조업체의 설명서를 참조하십시오. \"", "3. TP-LINK 공식 웹 사이트에서 리소스 CD (Windows 전용) 또는 TP-LINK (Windows 및 Mac OS X 용)에서 TP-LINK USB 프린터 컨트롤러 유틸리티를 다운로드하십시오."]
                }
            ]
        },
        BASIC_PARENTAL_CONTROL: {
            TITLE: "자녀 보호",
            CONTENT: [
                {
                    type: "name",
                    title: "상태",
                    content: "자녀 보호 기능을 사용하려면 켜기를 선택하십시오. 기본적으로이 기능은 비활성화되어 있습니다."
                }
            ]
        },
        BASIC_PARENTAL_DEVICE: {
            TITLE: "부모 제어 장치",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "유해 컨텐츠 차단 아래에있는 장치 목록을 표시합니다."
                }, {
                    type: "name",
                    title: "장치 이름",
                    content: "현재 부모 권한으로 연결되어있는 연결된 모든 클라이언트 장치의 이름을 표시합니다."
                }, {
                    type: "name",
                    title: "MAC 주소",
                    content: "현재 유해 컨텐츠 차단 상태에있는 연결된 모든 클라이언트 장치의 MAC 주소를 표시합니다."
                }, {
                    type: "name",
                    title: "인터넷 접속 시간",
                    content: "제한 액세스 시간을 표시합니다."
                }, {
                    type: "name",
                    title: "설명",
                    content: "연결된 장치에 대한 간략한 설명을 표시합니다. 선택적 설정입니다."
                }, {
                    type: "name",
                    title: "상태",
                    content: "해당 장치의 유해 컨텐츠 차단의 현재 상태 (활성화 또는 비활성화)를 표시합니다."
                }, {
                    type: "name",
                    title: "수정",
                    content: "해당 장치 수정 또는 삭제 옵션을 표시합니다."
                }, {
                    type: "step",
                    title: "새 클라이언트 장치를 제한하려면",
                    content: [
                        "1. 추가를 클릭하십시오.",
                        "2. 기존 장치보기를 클릭하고 액세스 장치 목록에서 현재 연결된 장치를 선택하거나 장치 이름과 MAC 주소를 수동으로 입력하여 연결되지 않은 장치를 추가하십시오. ",
                        "3. 인터넷 액세스 시간 아이콘을 클릭하여 제한이 적용되는 기간을 지정하십시오.",
                        "4. 설명 필드에 간단한 설명을 입력하십시오. (선택 과목)",
                        "5. 사용을 선택하십시오.",
                        "6. 확인을 클릭하여이 항목을 저장합니다."
                    ]
                }, {
                    type: "paragraph",
                    content: "유해 컨텐츠 차단 (Parental Control) 항목을 수정하거나 삭제하려면 수정 아이콘을 클릭하여 정보를 편집하거나 삭제 아이콘을 클릭하여 해당 항목을 제거하십시오."
                }, {
                    type: "paragraph",
                    content: "여러 항목을 삭제하려면 모든 항목을 선택하고 표 위에서 삭제를 클릭하십시오."
                }
            ]
        },
        BASIC_GUEST_NETWORK: {
            TITLE: "게스트 네트워크",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "게스트 네트워크를 사용하면 게스트가 무선 네트워크에 액세스하는 데 사용할 수있는 별도의 무선 네트워크 이름 (SSID)과 암호로 별도의 네트워크를 설정할 수 있습니다."
                }, {
                    type: "name",
                    title: "게스트 서로를 볼 수 있도록 허용하십시오.",
                    content: "게스트 네트워크의 무선 장치가 서로를 볼 수있게하려면이 확인란을 선택합니다."
                }, {
                    type: "name",
                    title: "게스트 내 네트워크를 관리하는 것을 허용하지 마십시오.",
                    content: "게스트가 웹 관리 인터페이스에 로그인하지 못하도록하려면 이 옵션을 선택합니다."
                }, {
                    type: "name",
                    title: "게스트 네트워크 사용",
                    content: "2.4GHz / 5GHz 게스트 네트워크 기능을 사용하려면 이 확인란을 선택합니다."
                }, {
                    type: "name",
                    title: "무선 네트워크 이름 (SSID)",
                    content: "기본 게스트 SSID를 사용하거나 새 이름을 만듭니다 (최대 32 자)."
                }, {
                    type: "name",
                    title: "SSID 숨기기",
                    content: "Wi-Fi 네트워크 목록에서 Guest SSID를 숨기려면 이 확인란을 선택합니다."
                }, {
                    type: "name",
                    title: "암호",
                    content: "게스트 네트워크 보안을 위해 8 ~ 63 자의 ASCII 문자 또는 8 ~ 64 자의 16 진수 (0-9, a-f, A-F) 암호를 생성하십시오."
                }
            ]
        },
        "": ""
    };
})(jQuery);
